/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.util.Util;

public class KiwiLanguageProvider
implements class_2405 {
    protected final FabricDataOutput dataOutput;
    protected final String languageCode;

    public KiwiLanguageProvider(FabricDataOutput dataOutput) {
        this(dataOutput, "en_us");
    }

    public KiwiLanguageProvider(FabricDataOutput dataOutput, String languageCode) {
        this.dataOutput = dataOutput;
        this.languageCode = languageCode;
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        try {
            Path existingFilePath = this.createPath(this.languageCode + ".existing");
            translationBuilder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public Path createPath(String path) {
        return (Path)this.dataOutput.getModContainer().findPath("assets/%s/lang/%s.json".formatted(this.dataOutput.getModId(), path)).orElseThrow();
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        TreeMap<String, String> translationEntries = new TreeMap<String, String>();
        this.generateConfigEntries(translationEntries);
        this.generateTranslations((key, value) -> {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            if (translationEntries.containsKey(key)) {
                throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
            }
            translationEntries.put(key, value);
        });
        this.putExistingTranslations((key, value) -> {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            translationEntries.put(key, value);
        });
        JsonObject langEntryJson = new JsonObject();
        for (Map.Entry<String, String> entry : translationEntries.entrySet()) {
            langEntryJson.addProperty(entry.getKey(), entry.getValue());
        }
        return class_2405.method_10320((class_7403)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
    }

    private void generateConfigEntries(Map<String, String> translationEntries) {
        Joiner joiner = Joiner.on((char)'.');
        for (ConfigHandler handler : KiwiConfigManager.allConfigs) {
            if (!Objects.equals(handler.getModId(), this.dataOutput.getModId()) || handler.getFileName().equals("test") || handler.getFileName().equals("kiwi-modules")) continue;
            String key = handler.getTranslationKey();
            if (Objects.equals(key, handler.getFileName())) {
                translationEntries.put("kiwi.config." + key, Util.friendlyText(key));
            }
            HashSet subCats = Sets.newHashSet();
            for (ConfigHandler.Value<?> value : handler.getValueMap().values()) {
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String title = Util.friendlyText((String)path.remove(path.size() - 1));
                String subCatKey = joiner.join((Iterable)path);
                if (!path.isEmpty() && !subCats.contains(subCatKey)) {
                    subCats.add(subCatKey);
                    translationEntries.put(handler.getModId() + ".config." + subCatKey, Util.friendlyText((String)path.get(path.size() - 1)));
                }
                translationEntries.put(value.translation, title);
                translationEntries.put(value.translation + ".desc", "");
            }
        }
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39368, "lang").method_44107(new class_2960(this.dataOutput.getModId(), code));
    }

    public String method_10321() {
        return "Language (%s)".formatted(this.languageCode);
    }
}

