/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.gson.JsonElement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_3966;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.NBTHelper;

public final class Util {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");
    public static final MessageFormat MESSAGE_FORMAT = new MessageFormat("{0,number,#.#}");

    private Util() {
    }

    public static String color(int color) {
        return String.format("\u00a7x%06x", color & 0xFFFFFF);
    }

    public static String formatComma(long number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static String formatCompact(long number) {
        int unit = 1000;
        if (number < (long)unit) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(number) / Math.log(unit));
        if (exp - 1 >= 0 && exp - 1 < 6) {
            char pre = "kMGTPE".charAt(exp - 1);
            return MESSAGE_FORMAT.format(new Double[]{(double)number / Math.pow(unit, exp)}) + pre;
        }
        return Long.toString(number);
    }

    public static String trimRL(class_2960 rl) {
        return Util.trimRL(rl, "minecraft");
    }

    public static String trimRL(String rl) {
        return Util.trimRL(rl, "minecraft");
    }

    public static String trimRL(class_2960 rl, String defaultNamespace) {
        return rl.method_12836().equals(defaultNamespace) ? rl.method_12832() : rl.toString();
    }

    public static String trimRL(String rl, String defaultNamespace) {
        if (rl.startsWith(defaultNamespace + ":")) {
            return rl.substring(defaultNamespace.length() + 1);
        }
        return rl;
    }

    @Nullable
    public static class_2960 RL(@Nullable String string) {
        try {
            return class_2960.method_12829((String)string);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static class_2960 RL(@Nullable String string, String defaultNamespace) {
        if (string != null && !((String)string).contains(":")) {
            string = defaultNamespace + ":" + (String)string;
        }
        return Util.RL((String)string);
    }

    @Nullable
    public static class_2561 getBlockDefName(class_1799 stack, String key) {
        BlockDefinition def;
        NBTHelper data = NBTHelper.of(stack);
        class_2487 tag = data.getTag("BlockEntityTag.Overrides." + key);
        if (tag != null && (def = BlockDefinition.fromNBT(tag)) != null) {
            return def.getDescription();
        }
        return null;
    }

    @Nullable
    public static class_1863 getRecipeManager() {
        class_634 connection;
        MinecraftServer server = Platform.getServer();
        if (server != null) {
            return server.method_3772();
        }
        if (Platform.isPhysicalClient() && (connection = class_310.method_1551().method_1562()) != null) {
            return connection.method_2877();
        }
        return null;
    }

    public static <C extends class_1263, T extends class_1860<C>> List<T> getRecipes(class_3956<T> recipeTypeIn) {
        class_1863 manager = Util.getRecipeManager();
        if (manager == null) {
            return Collections.EMPTY_LIST;
        }
        return Util.getRecipeManager().method_30027(recipeTypeIn);
    }

    public static int friendlyCompare(String a, String b) {
        int aLength = a.length();
        int bLength = b.length();
        int minSize = Math.min(aLength, bLength);
        boolean asNumeric = false;
        int lastNumericCompare = 0;
        for (int i = 0; i < minSize; ++i) {
            boolean bNumber;
            char aChar = a.charAt(i);
            char bChar = b.charAt(i);
            boolean aNumber = aChar >= '0' && aChar <= '9';
            boolean bl = bNumber = bChar >= '0' && bChar <= '9';
            if (asNumeric) {
                if (aNumber && bNumber) {
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aNumber) {
                    return 1;
                }
                if (bNumber) {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    if (aChar != bChar) {
                        return aChar - bChar;
                    }
                    asNumeric = false;
                    continue;
                }
                return lastNumericCompare;
            }
            if (aNumber && bNumber) {
                asNumeric = true;
                if (lastNumericCompare != 0) continue;
                lastNumericCompare = aChar - bChar;
                continue;
            }
            if (aChar == bChar) continue;
            return aChar - bChar;
        }
        if (asNumeric) {
            if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                return 1;
            }
            if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                return -1;
            }
            if (lastNumericCompare == 0) {
                return aLength - bLength;
            }
            return lastNumericCompare;
        }
        return aLength - bLength;
    }

    public static String friendlyText(String s) {
        StringBuilder sb = new StringBuilder();
        MutableBoolean lastIsUpper = new MutableBoolean(true);
        s.codePoints().forEach(ch -> {
            if (Character.isUpperCase(ch) && lastIsUpper.isFalse()) {
                sb.append(' ');
            } else if (Character.isLowerCase(ch)) {
                if (sb.isEmpty()) {
                    ch = Character.toUpperCase(ch);
                } else if (lastIsUpper.isTrue() && sb.length() > 1 && Character.isUpperCase(sb.codePointAt(sb.length() - 2))) {
                    sb.insert(sb.length() - 1, ' ');
                }
            }
            lastIsUpper.setValue(Character.isUpperCase(ch));
            sb.appendCodePoint(ch);
        });
        return sb.toString();
    }

    public static boolean canPlayerBreak(class_1657 player, class_2680 state, class_2338 pos) {
        if (!player.method_7294() || !player.method_37908().method_8505(player, pos)) {
            return false;
        }
        return player.method_7337() || !(state.method_26165(player, (class_1922)player.method_37908(), pos) <= 0.0f);
    }

    public static int applyAlpha(int color, float alpha) {
        int alphaChannel;
        int prevAlphaChannel = color >> 24 & 0xFF;
        if (prevAlphaChannel > 0) {
            alpha *= (float)prevAlphaChannel / 256.0f;
        }
        if ((alphaChannel = (int)(255.0f * class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f))) < 5) {
            return 0;
        }
        return color & 0xFFFFFF | alphaChannel << 24;
    }

    public static float getPickRange(class_1657 player) {
        float attrib = 5.0f;
        return player.method_7337() ? attrib : attrib - 0.5f;
    }

    public static void displayClientMessage(@Nullable class_1657 player, boolean client, String key, Object ... args) {
        if (player == null) {
            return;
        }
        if (client != player.method_37908().field_9236) {
            return;
        }
        player.method_43496((class_2561)class_2561.method_43469((String)key, (Object[])args));
    }

    public static void jsonList(JsonElement json, Consumer<JsonElement> collector) {
        if (json.isJsonArray()) {
            for (JsonElement e : json.getAsJsonArray()) {
                collector.accept(e);
            }
        } else {
            collector.accept(json);
        }
    }

    @Nullable
    public static String[] readNBTStrings(class_2487 tag, String key, @Nullable String[] strings) {
        if (!tag.method_10573(key, 9)) {
            return null;
        }
        class_2499 list = tag.method_10554(key, 8);
        if (list.isEmpty()) {
            return null;
        }
        if (strings == null || strings.length != list.size()) {
            strings = new String[list.size()];
        }
        for (int i = 0; i < strings.length; ++i) {
            String s;
            strings[i] = s = list.method_10608(i);
        }
        return strings;
    }

    public static void writeNBTStrings(class_2487 tag, String key, @Nullable String[] strings) {
        if (strings == null || strings.length == 0) {
            return;
        }
        class_2499 list = new class_2499();
        for (String s : strings) {
            list.add((Object)class_2519.method_23256((String)s));
        }
        tag.method_10566(key, (class_2520)list);
    }

    public static class_1269 onAttackEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        class_1799 stack;
        class_1533 frame;
        if (entity instanceof class_1533 && !(frame = (class_1533)entity).method_6940().method_7960() && !frame.method_5740() && !frame.method_5655() && (stack = player.method_5998(hand)).method_31574(class_1802.field_8827)) {
            frame.method_5648(!frame.method_5767());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }
}

