/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.item.ItemCategoryFiller;

public class GroupSetting {
    private static final Multimap<CreativeModeTab, Pair<List<ItemStack>, ItemCategoryFiller>> toAdd = HashMultimap.create();
    private String[] groups;
    private String[] after;

    public static GroupSetting of(KiwiModule.Category category, GroupSetting preset) {
        if (preset != null && category.value().length == 0) {
            return new GroupSetting(preset.groups, category.after());
        }
        return new GroupSetting(category.value(), category.after());
    }

    public GroupSetting(String[] groups, String[] after) {
        this.groups = groups;
        this.after = after;
    }

    public void apply(ItemCategoryFiller filler) {
        List<CreativeModeTab> tabs = Stream.of(this.groups).map(Kiwi::getGroup).filter(Objects::nonNull).toList();
        List<ItemStack> afterItems = Stream.of(this.after).map(ResourceLocation::m_135820_).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).filter(Predicate.not(Items.f_41852_::equals)).map(ItemStack::new).toList();
        for (CreativeModeTab tab : tabs) {
            toAdd.put((Object)tab, (Object)Pair.of(afterItems, (Object)filler));
        }
    }

    private static void addAfter(List<ItemStack> toAdd, MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, List<ItemStack> afterItems) {
        ItemStack lastFound = ItemStack.f_41583_;
        if (!afterItems.isEmpty()) {
            for (int i = 0; i < afterItems.size(); ++i) {
                ItemStack stack = afterItems.get(afterItems.size() - i - 1);
                if (!map.contains((Object)stack)) continue;
                lastFound = stack;
                break;
            }
        }
        for (ItemStack item : toAdd) {
            if (lastFound.m_41619_()) {
                map.put((Object)item, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                continue;
            }
            map.putAfter((Object)lastFound, (Object)item, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static List<ItemStack> getEnabledStacks(List<ItemStack> newStacks, FeatureFlagSet enabledFeatures) {
        if (newStacks.stream().allMatch($ -> GroupSetting.isEnabled($, enabledFeatures))) {
            return newStacks;
        }
        return newStacks.stream().filter($ -> GroupSetting.isEnabled($, enabledFeatures)).toList();
    }

    private static boolean isEnabled(ItemStack stack, FeatureFlagSet enabledFeatures) {
        return stack.m_41720_().m_245993_(enabledFeatures);
    }

    private static void buildContents(BuildCreativeModeTabContentsEvent event) {
        for (Pair pair : toAdd.get((Object)event.getTab())) {
            List<Object> items = Lists.newArrayList();
            ((ItemCategoryFiller)pair.getRight()).fillItemCategory(event.getTab(), event.getFlags(), event.hasPermissions(), (List<ItemStack>)items);
            items = GroupSetting.getEnabledStacks((List<ItemStack>)items, event.getFlags());
            if (items.isEmpty()) continue;
            GroupSetting.addAfter(items, (MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries(), (List)pair.getLeft());
        }
    }

    static {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(GroupSetting::buildContents);
    }
}

