/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.util.Util;

public class KiwiLanguageProvider
implements DataProvider {
    protected final FabricDataOutput dataOutput;
    protected final String languageCode;

    public KiwiLanguageProvider(FabricDataOutput dataOutput) {
        this(dataOutput, "en_us");
    }

    public KiwiLanguageProvider(FabricDataOutput dataOutput, String languageCode) {
        this.dataOutput = dataOutput;
        this.languageCode = languageCode;
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        try {
            Path existingFilePath = this.createPath(this.languageCode + ".existing");
            translationBuilder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public Path createPath(String path) {
        return this.dataOutput.getForgeModContainer().getOwningFile().getFile().findResource(new String[]{"assets/%s/lang/%s.json".formatted(this.dataOutput.getModId(), path)});
    }

    public CompletableFuture<?> m_213708_(CachedOutput writer) {
        TreeMap<String, String> translationEntries = new TreeMap<String, String>();
        this.generateConfigEntries(translationEntries);
        this.generateTranslations((key, value) -> {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            if (translationEntries.containsKey(key)) {
                throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
            }
            translationEntries.put(key, value);
        });
        this.putExistingTranslations((key, value) -> {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            translationEntries.put(key, value);
        });
        JsonObject langEntryJson = new JsonObject();
        for (Map.Entry<String, String> entry : translationEntries.entrySet()) {
            langEntryJson.addProperty(entry.getKey(), entry.getValue());
        }
        return DataProvider.m_253162_((CachedOutput)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
    }

    private void generateConfigEntries(Map<String, String> translationEntries) {
        Joiner joiner = Joiner.on((char)'.');
        for (ConfigHandler handler : KiwiConfigManager.allConfigs) {
            if (!Objects.equals(handler.getModId(), this.dataOutput.getModId()) || handler.getFileName().equals("test") || handler.getFileName().equals("kiwi-modules")) continue;
            String key = handler.getTranslationKey();
            if (Objects.equals(key, handler.getFileName())) {
                translationEntries.put("kiwi.config." + key, Util.friendlyText(key));
            }
            HashSet subCats = Sets.newHashSet();
            for (ConfigHandler.Value<?> value : handler.getValueMap().values()) {
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String title = Util.friendlyText((String)path.remove(path.size() - 1));
                String subCatKey = joiner.join((Iterable)path);
                if (!path.isEmpty() && !subCats.contains(subCatKey)) {
                    subCats.add(subCatKey);
                    translationEntries.put(handler.getModId() + ".config." + subCatKey, Util.friendlyText((String)path.get(path.size() - 1)));
                }
                translationEntries.put(value.translation, title);
                translationEntries.put(value.translation + ".desc", "");
            }
        }
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "lang").m_245731_(new ResourceLocation(this.dataOutput.getModId(), code));
    }

    public String m_6055_() {
        return "Language (%s)".formatted(this.languageCode);
    }
}

