/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ShapeCaches;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.block.entity.SnowCoveredBlockEntity;
import snownee.snow.mixin.FenceGateBlockAccess;

public class SnowFenceGateBlock
extends FenceGateBlock
implements EntityBlock,
WatcherSnowVariant {
    public SnowFenceGateBlock(BlockBehaviour.Properties properties) {
        super(properties, WoodType.f_61830_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCaches.get(ShapeCaches.COLLIDER, state, worldIn, pos, () -> {
            VoxelShape shape = super.m_5939_(state, worldIn, pos, context);
            return Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.getSnowState(state, worldIn, pos).m_60742_(worldIn, pos, context));
        });
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return ShapeCaches.get(ShapeCaches.VISUAL, state, worldIn, pos, () -> {
            VoxelShape shape = super.m_7952_(state, worldIn, pos);
            return Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.getSnowState(state, worldIn, pos).m_60768_(worldIn, pos));
        });
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.m_60742_(worldIn, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCaches.get(ShapeCaches.OUTLINE, state, worldIn, pos, () -> {
            VoxelShape shape = super.m_5940_(state, worldIn, pos, context);
            return Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.getSnowState(state, worldIn, pos).m_60651_(worldIn, pos, context));
        });
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SnowCoveredBlockEntity(pos, state);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (SnowCommonConfig.retainOriginalBlocks || ModUtil.shouldMelt((Level)worldIn, pos)) {
            worldIn.m_46597_(pos, this.getRaw(state, (BlockGetter)worldIn, pos));
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        this.adjustSounds(blockState, level, blockPos);
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        this.adjustSounds(blockState, level, blockPos);
        SnowCoveredBlockEntity.updateOptions(level, blockPos);
        super.m_6861_(blockState, level, blockPos, block, blockPos2, bl);
    }

    private void adjustSounds(BlockState blockState, Level level, BlockPos blockPos) {
        BlockState raw = this.getRaw(blockState, (BlockGetter)level, blockPos);
        if (raw.m_60734_() instanceof FenceGateBlock) {
            FenceGateBlockAccess rawFenceGate = (FenceGateBlockAccess)raw.m_60734_();
            FenceGateBlockAccess fenceGate = (FenceGateBlockAccess)blockState.m_60734_();
            fenceGate.setOpenSound(rawFenceGate.getOpenSound());
            fenceGate.setCloseSound(rawFenceGate.getCloseSound());
        }
    }
}

