/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;
import snownee.snow.CoreModule;
import snownee.snow.WrappedSoundType;
import snownee.snow.block.entity.SnowBlockEntity;

public interface SnowVariant
extends IForgeBlock {
    default public BlockState getRaw(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity tile;
        if (state.m_155947_() && (tile = world.m_7702_(pos)) instanceof SnowBlockEntity) {
            return ((SnowBlockEntity)tile).getState();
        }
        return Blocks.f_50016_.m_49966_();
    }

    default public BlockState onShovel(BlockState state, Level world, BlockPos pos) {
        return this.getRaw(state, (BlockGetter)world, pos);
    }

    default public double getYOffset() {
        return 0.0;
    }

    default public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getRaw(state, world, pos).getCloneItemStack(target, world, pos, player);
    }

    default public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        if (state.m_155947_() && !(state.m_60734_() instanceof SnowLayerBlock)) {
            return WrappedSoundType.get(this.getRaw(state, (BlockGetter)world, pos).getSoundType(world, pos, entity));
        }
        return super.getSoundType(state, world, pos, entity);
    }

    default public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (this.layers(state, (BlockGetter)level, pos) > 0 && queryState != null && queryState.m_204336_(BlockTags.f_144279_)) {
            return this.getSnowState(state, (BlockGetter)level, pos);
        }
        return this.getRaw(state, (BlockGetter)level, pos);
    }

    default public int layers(BlockState state, BlockGetter world, BlockPos pos) {
        return world.m_141902_(pos, (BlockEntityType)CoreModule.TEXTURE_TILE.get()).map(be -> be.options.renderBottom ? 1 : 0).orElse(0);
    }

    default public BlockState getSnowState(BlockState state, BlockGetter world, BlockPos pos) {
        int layers = this.layers(state, world, pos);
        return layers == 0 ? Blocks.f_50016_.m_49966_() : (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(layers));
    }
}

