/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.network.NetworkHooks;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;

public class FallingSnowEntity
extends Entity {
    public int fallTime;
    private BlockPos prevPos;
    private int layers;
    protected static final EntityDataAccessor<BlockPos> START_POS = SynchedEntityData.m_135353_(FallingSnowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> LAYERS = SynchedEntityData.m_135353_(FallingSnowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EntityDimensions size;

    public FallingSnowEntity(Level worldIn) {
        super((EntityType)CoreModule.ENTITY.get(), worldIn);
        this.prevPos = BlockPos.f_121853_;
        this.layers = 1;
        this.size = new EntityDimensions(0.98f, 0.1225f * (float)this.layers, true);
    }

    public FallingSnowEntity(EntityType<FallingSnowEntity> type, Level worldIn) {
        this(worldIn);
    }

    public FallingSnowEntity(Level worldIn, double x, double y, double z, int layers) {
        super((EntityType)CoreModule.ENTITY.get(), worldIn);
        this.f_19850_ = true;
        this.m_6034_(x, y + (double)((1.0f - this.m_20206_()) / 2.0f), z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.layers = layers;
        this.prevPos = this.m_20183_();
        this.setData(this.prevPos, layers);
        this.size = new EntityDimensions(0.98f, 0.1225f * (float)layers, true);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.size;
    }

    public void m_8119_() {
        ++this.fallTime;
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        BlockPos pos = this.m_20183_();
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            if (!this.m_20096_()) {
                if (this.fallTime > 600 || this.fallTime > 100 && level.m_151570_(pos)) {
                    this.m_146870_();
                } else if (!pos.equals((Object)this.prevPos)) {
                    this.prevPos = pos;
                    BlockState state = level.m_8055_(pos);
                    if (SnowCommonConfig.snowMakingIce && state.m_60713_(Blocks.f_49990_)) {
                        level.m_46597_(pos, Blocks.f_50126_.m_49966_());
                        this.m_146870_();
                        return;
                    }
                    if (state.m_60819_().m_205070_(FluidTags.f_13132_)) {
                        if (level.f_46443_) {
                            RandomSource random = level.f_46441_;
                            for (int i = 0; i < 10; ++i) {
                                double d0 = random.m_188583_() * 0.02;
                                double d1 = random.m_188583_() * 0.02;
                                double d2 = random.m_188583_() * 0.02;
                                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + random.m_188501_()), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + random.m_188501_()), d0, d1, d2);
                            }
                        }
                        level.m_5594_(null, pos.m_7494_(), SoundEvents.f_12030_, SoundSource.AMBIENT, 0.8f, 0.8f);
                        this.m_146870_();
                        return;
                    }
                    if (!state.m_60819_().m_76178_()) {
                        this.m_146870_();
                        return;
                    }
                }
            } else {
                BlockState state = level.m_8055_(pos);
                this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                if (state.m_60734_() != Blocks.f_50110_) {
                    BlockPos posDown;
                    BlockState stateDown;
                    Block block;
                    if (state.m_60742_((BlockGetter)level, pos, CollisionContext.m_82750_((Entity)this)).m_83281_() && ((block = (stateDown = level.m_8055_(posDown = pos.m_7495_())).m_60734_()) instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof StairBlock && stateDown.m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM)) {
                        pos = posDown;
                    }
                    Hooks.placeLayersOn(level, pos, this.layers, true, (BlockPlaceContext)new DirectionalPlaceContext(level, pos, Direction.DOWN, ItemStack.f_41583_, Direction.UP), true, true);
                    this.m_146870_();
                    return;
                }
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    public void setData(BlockPos pos, int layers) {
        this.f_19804_.m_135381_(START_POS, (Object)pos);
        this.f_19804_.m_135381_(LAYERS, (Object)layers);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.f_19804_.m_135370_(START_POS);
    }

    public int getLayers() {
        return (Integer)this.f_19804_.m_135370_(LAYERS);
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_6051_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6097_() {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(START_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(LAYERS, (Object)1);
    }

    protected void m_7378_(CompoundTag compound) {
        this.fallTime = compound.m_128451_("Time");
        if (compound.m_128425_("Layers", 3)) {
            this.layers = compound.m_128451_("Layers");
            this.size = new EntityDimensions(0.98f, 0.1225f * (float)this.layers, true);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Time", this.fallTime);
        compound.m_128405_("Layers", this.layers);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

