/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.google.common.collect.ImmutableList;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.init.StatueSounds;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueTile;
import com.shynieke.statues.util.ListHelper;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CampfireStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)7.0, (double)11.0);
    public static List<SoundEvent> campfire_sounds = ImmutableList.of((Object)StatueSounds.campfire_bye_random, (Object)StatueSounds.campfire_cold_random, (Object)StatueSounds.campfire_greetings_random, (Object)StatueSounds.campfire_hello_random, (Object)StatueSounds.campfire_snacks_random);

    public CampfireStatueBlock(AbstractBlock.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d).func_235838_a_(p_235418_0_ -> 12));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
        return direction.func_176740_k() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }

    @Override
    public void executeStatueBehavior(StatueTile tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
        tile.summonMob((LivingEntity)this.getGeneral(worldIn));
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return CampfireStatueBlock.getRandomCampfire();
    }

    public CreeperEntity getGeneral(World worldIn) {
        CreeperEntity general = new CreeperEntity(EntityType.field_200797_k, worldIn);
        general.func_200203_b((ITextComponent)new StringTextComponent("General Spazz"));
        CompoundNBT tag = new CompoundNBT();
        tag.func_74774_a("ExplosionRadius", (byte)0);
        general.func_213281_b(tag);
        return general;
    }

    public static SoundEvent getRandomCampfire() {
        return ListHelper.getRandomFromList(campfire_sounds);
    }

    @Override
    public String getLootName() {
        return "etho";
    }

    @Override
    public boolean isHiddenStatue() {
        return true;
    }
}

