/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.config.StatuesConfig;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.ModList;

public class InfoStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.5, (double)13.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)5.5, (double)4.5, (double)5.5, (double)10.5, (double)7.0, (double)10.5);
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TOP_SHAPE);

    public InfoStatueBlock(AbstractBlock.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        this.sendInfoMessage(playerIn, worldIn, pos);
        return ActionResultType.SUCCESS;
    }

    public void sendInfoMessage(PlayerEntity player, World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            int random = worldIn.field_73012_v.nextInt(100);
            ArrayList<String> messages = new ArrayList<String>((Collection)StatuesConfig.COMMON.info_messages.get());
            List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
            if (ModList.get().isLoaded("veinminer")) {
                messages.add("Did you know we have veinminer");
            }
            if (ModList.get().isLoaded("curios")) {
                messages.add("Did you know we have curios support");
            }
            int idx = new Random().nextInt(messages.size());
            Object randomMessage = new StringTextComponent((String)messages.get(idx));
            if (!luckyPlayers.isEmpty() && random < 20) {
                for (String luckyPlayer : luckyPlayers) {
                    if (luckyPlayer.isEmpty()) continue;
                    String luckyUser = luckyPlayer.trim();
                    if (!player.func_145748_c_().func_150261_e().equalsIgnoreCase(luckyUser)) continue;
                    randomMessage = new StringTextComponent("Luck is not on your side today");
                }
            } else {
                LocalDate localdate = LocalDate.now();
                int i = localdate.get(ChronoField.DAY_OF_MONTH);
                int j = localdate.get(ChronoField.MONTH_OF_YEAR);
                randomMessage = worldIn.field_73012_v.nextDouble() <= 0.3 && j == 11 && i <= 20 ? new StringTextComponent("Please check out our friends over at ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_(ForgeHooks.newChatWithLinks((String)"https://lovetropics.com/")) : new StringTextComponent((String)messages.get(idx));
            }
            player.func_145747_a((ITextComponent)randomMessage, Util.field_240973_b_);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187576_at, SoundCategory.NEUTRAL, 0.5f, 1.0f);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

