/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.entity.PlayerStatueEntity;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.init.StatueTags;
import com.shynieke.statues.items.PlayerStatueItem;
import com.shynieke.statues.tiles.PlayerTile;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty ONLINE = BooleanProperty.func_177716_a((String)"online");

    public PlayerStatueBlock(AbstractBlock.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).func_206870_a((Property)ONLINE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PlayerTile();
    }

    private PlayerTile getTE(World world, BlockPos pos) {
        return (PlayerTile)world.func_175625_s(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof PlayerTile && ((INameable)te).func_145818_k_()) {
            PlayerTile tile = (PlayerTile)te;
            player.func_71020_j(0.005f);
            if (worldIn.field_72995_K) {
                return;
            }
            if (this == Blocks.field_150350_a) {
                return;
            }
            ItemStack itemstack = new ItemStack((IItemProvider)this);
            itemstack.func_200302_a(tile.func_200200_C_());
            if (tile.getPlayerProfile() != null) {
                CompoundNBT stackTag = itemstack.func_77978_p() != null ? itemstack.func_77978_p() : new CompoundNBT();
                CompoundNBT nbttagcompound = new CompoundNBT();
                NBTUtil.func_180708_a((CompoundNBT)nbttagcompound, (GameProfile)tile.getPlayerProfile());
                stackTag.func_218657_a("PlayerProfile", (INBT)nbttagcompound);
                itemstack.func_77982_d(stackTag);
                itemstack.func_200302_a(tile.func_200200_C_());
            }
            PlayerStatueBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
            if (tile.getComparatorApplied()) {
                PlayerStatueBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Blocks.field_196762_fd.func_199767_j()));
            }
        } else {
            super.func_180657_a(worldIn, player, pos, state, null, stack);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (state.hasTileEntity() && newState.func_177230_c() != StatueRegistry.PLAYER_STATUE.get()) {
            worldIn.func_175713_t(pos);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof PlayerTile) {
            PlayerTile playerTile = (PlayerTile)tileentity;
            ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c());
            GameProfile profile = playerTile.getPlayerProfile();
            if (profile != null) {
                CompoundNBT tag = new CompoundNBT();
                if (!StringUtils.func_151246_b((String)profile.getName())) {
                    GameProfile gameprofile = new GameProfile((UUID)null, profile.getName());
                    gameprofile = PlayerTile.updateGameProfile(gameprofile);
                    tag.func_218657_a("PlayerProfile", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameprofile));
                }
                stack.func_77982_d(tag);
            }
            return stack.func_200302_a(playerTile.func_200200_C_());
        }
        return new ItemStack((IItemProvider)state.func_177230_c());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, (BlockState)state.func_206870_a((Property)ONLINE, (Comparable)Boolean.valueOf(false)), placer, stack);
        if (!worldIn.field_72995_K && this.getTE(worldIn, pos) != null) {
            PlayerTile tile = this.getTE(worldIn, pos);
            if (stack.func_82837_s()) {
                String stackName = stack.func_200301_q().func_150261_e();
                boolean spaceFlag = stackName.contains(" ");
                boolean emptyFlag = stackName.isEmpty();
                if (!spaceFlag && !emptyFlag) {
                    GameProfile foundProfile;
                    CompoundNBT tag;
                    GameProfile newProfile = new GameProfile((UUID)null, stackName);
                    if (stack.func_77942_o() && stack.func_77978_p() != null && (tag = stack.func_77978_p()).func_74764_b("PlayerProfile") && (foundProfile = NBTUtil.func_152459_a((CompoundNBT)tag.func_74775_l("PlayerProfile"))) != null && foundProfile.getName().equalsIgnoreCase(stackName)) {
                        newProfile = foundProfile;
                    }
                    tile.setPlayerProfile(newProfile);
                }
            } else if (placer instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)placer;
                tile.setPlayerProfile(player.func_146103_bH());
            } else {
                tile.setPlayerProfile(new GameProfile((UUID)null, "steve"));
            }
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() && stack.func_77942_o()) {
            GameProfile gameprofile;
            CompoundNBT profileTag;
            CompoundNBT tag = stack.func_77978_p();
            tooltip.add((ITextComponent)new StringTextComponent("Username: " + stack.func_200301_q().func_150261_e()).func_240699_a_(TextFormatting.GOLD));
            if (tag != null && tag.func_74764_b("PlayerProfile") && (profileTag = (CompoundNBT)tag.func_74781_a("PlayerProfile")) != null && (gameprofile = NBTUtil.func_152459_a((CompoundNBT)profileTag)) != null && !StringUtils.func_151246_b((String)gameprofile.getName())) {
                tooltip.add((ITextComponent)new StringTextComponent("UUID: " + gameprofile.getId().toString()).func_240699_a_(TextFormatting.GOLD));
            }
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)ONLINE)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)ONLINE);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, WATERLOGGED, ONLINE});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = playerIn.func_184586_b(hand);
        GameProfile tileProfile = this.getTE(worldIn, pos).getPlayerProfile();
        PlayerTile tile = this.getTE(worldIn, pos);
        if (!worldIn.field_72995_K && tile != null && tileProfile != null) {
            boolean onlineFlag;
            String playerName = tileProfile.getName();
            boolean bl = onlineFlag = worldIn.func_217371_b(tileProfile.getId()) != null;
            if (playerIn.func_225608_bj_()) {
                if (tile.getComparatorApplied()) {
                    tile.setComparatorApplied(false);
                    ItemStack comparatorStack = new ItemStack((IItemProvider)Items.field_222029_iU);
                    if (!playerIn.func_191521_c(comparatorStack)) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), comparatorStack));
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (((Boolean)StatuesConfig.COMMON.playerCompass.get()).booleanValue()) {
                if (stack.func_77973_b() == Items.field_151111_aL || stack.func_77973_b() == StatueRegistry.PLAYER_COMPASS.get()) {
                    boolean isPlayerCompass;
                    boolean bl2 = isPlayerCompass = stack.func_77973_b() == StatueRegistry.PLAYER_COMPASS.get();
                    if (onlineFlag) {
                        ItemStack playerCompass = isPlayerCompass ? stack : new ItemStack((IItemProvider)StatueRegistry.PLAYER_COMPASS.get());
                        CompoundNBT locationTag = new CompoundNBT();
                        PlayerEntity player = worldIn.func_217371_b(tileProfile.getId());
                        if (player != null && player.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)playerIn.field_70170_p.func_234923_W_().func_240901_a_())) {
                            BlockPos playerPos = player.func_233580_cy_();
                            locationTag.func_74772_a("lastPlayerLocation", playerPos.func_218275_a());
                            locationTag.func_74778_a("playerTracking", tileProfile.getName());
                            playerCompass.func_77982_d(locationTag);
                            if (!isPlayerCompass) {
                                if (!playerIn.field_71075_bZ.field_75098_d) {
                                    stack.func_190918_g(1);
                                }
                                if (stack.func_190926_b()) {
                                    playerIn.func_184611_a(hand, playerCompass);
                                } else if (!playerIn.field_71071_by.func_70441_a(playerCompass)) {
                                    playerIn.func_71019_a(playerCompass, false);
                                }
                            }
                        } else {
                            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("statues:player.compass.dimension.failure", new Object[]{TextFormatting.GOLD + playerName}), Util.field_240973_b_);
                        }
                    } else {
                        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("statues:player.compass.offline", new Object[]{TextFormatting.GOLD + playerName}), Util.field_240973_b_);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_77973_b() == Items.field_222029_iU && !tile.getComparatorApplied()) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    tile.setComparatorApplied(true);
                    tile.updateOnline();
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_77973_b().func_206844_a(StatueTags.PLAYER_UPGRADE_ITEM) && worldIn instanceof ServerWorld) {
                    ServerWorld serverworld = (ServerWorld)worldIn;
                    PlayerStatueEntity playerStatueEntity = (PlayerStatueEntity)((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get()).func_220349_b(serverworld, stack.func_77978_p(), tile.func_200200_C_(), playerIn, pos, SpawnReason.SPAWN_EGG, true, true);
                    if (playerStatueEntity == null) {
                        return ActionResultType.FAIL;
                    }
                    serverworld.func_242417_l((Entity)playerStatueEntity);
                    float f = (float)MathHelper.func_76141_d((float)((MathHelper.func_76142_g((float)(playerIn.field_70177_z - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                    playerStatueEntity.func_70012_b(playerStatueEntity.func_226277_ct_(), playerStatueEntity.func_226278_cu_(), playerStatueEntity.func_226281_cx_(), f, 0.0f);
                    PlayerStatueItem.applyRandomRotations(playerStatueEntity, worldIn.field_73012_v);
                    playerStatueEntity.setGameProfile(tile.getPlayerProfile());
                    worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    worldIn.func_217376_c((Entity)playerStatueEntity);
                    worldIn.func_184148_a((PlayerEntity)null, playerStatueEntity.func_226277_ct_(), playerStatueEntity.func_226278_cu_(), playerStatueEntity.func_226281_cx_(), SoundEvents.field_187710_m, SoundCategory.BLOCKS, 0.75f, 0.8f);
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                }
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_206870_a((Property)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)field_185512_D))).func_206870_a((Property)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

