/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues.fish;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.tiles.StatueTile;
import com.shynieke.statues.tiles.TropicalFishTile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FishStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    private static final VoxelShape SHAPE_BIG = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private final int size;

    public FishStatueBlock(AbstractBlock.Properties builder, int size) {
        super(builder.func_200947_a(SoundType.field_185851_d));
        this.size = size;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (this.size == 1) {
            return SHAPE_BIG;
        }
        return SHAPE;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        ItemStack stack = playerIn.func_184586_b(Hand.MAIN_HAND);
        if (stack.func_77973_b() == Items.field_221648_al) {
            TropicalFishTile tile = this.getFishTE((IBlockReader)worldIn, pos);
            tile.scrambleColors();
            worldIn.func_184138_a(pos, state, state, 6);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187900_fz, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                if (!playerIn.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_221646_ak))) {
                    ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p());
                    itemEntity.func_92058_a(stack);
                    worldIn.func_217376_c((Entity)itemEntity);
                }
            }
        }
        return super.func_225533_a_(state, worldIn, pos, playerIn, handIn, result);
    }

    @Override
    public void executeStatueBehavior(StatueTile tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TropicalFishTile();
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.field_204262_at;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.field_204413_iX;
    }

    public TropicalFishTile getFishTE(IBlockReader world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof TropicalFishTile ? (TropicalFishTile)world.func_175625_s(pos) : null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TropicalFishTile tile = this.getFishTE((IBlockReader)worldIn, pos);
        if (tile != null) {
            tile.scrambleColors();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(BlockState state, IBlockReader world, BlockPos pos, int tintIndex) {
        TileEntity tile;
        if (pos != null && (tile = world.func_175625_s(pos)) instanceof TropicalFishTile) {
            TropicalFishTile fishTile = (TropicalFishTile)tile;
            return tintIndex == 1 ? FishStatueBlock.fromColor(fishTile.getMainColor()) : (tintIndex == 2 ? FishStatueBlock.fromColor(fishTile.getSecondaryColor()) : -1);
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int fromColor(int color) {
        return DyeColor.func_196056_a((int)color).getColorValue();
    }
}

