/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.shynieke.statues.client.model.PlayerStatueModel;
import com.shynieke.statues.entity.PlayerStatueEntity;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class PlayerStatueRenderer
extends LivingRenderer<PlayerStatueEntity, PlayerStatueModel> {
    public static final PlayerStatueModel model = new PlayerStatueModel(0.03125f, false);
    public static final PlayerStatueModel slimModel = new PlayerStatueModel(0.03125f, true);

    public PlayerStatueRenderer(EntityRendererManager renderManager) {
        this(renderManager, false);
    }

    public PlayerStatueRenderer(EntityRendererManager manager, boolean useSmallArms) {
        super(manager, (EntityModel)new PlayerStatueModel(0.0f, useSmallArms), 0.0f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
    }

    public ResourceLocation getEntityTexture(PlayerStatueEntity entity) {
        return entity.getGameProfile().map(this::getSkin).orElseGet(() -> new ResourceLocation("minecraft:textures/entity/steve.png"));
    }

    private ResourceLocation getSkin(GameProfile gameProfile) {
        if (!gameProfile.isComplete()) {
            return new ResourceLocation("minecraft:textures/entity/steve.png");
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        SkinManager skinManager = minecraft.func_152342_ad();
        Map loadSkinFromCache = skinManager.func_152788_a(gameProfile);
        if (loadSkinFromCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return skinManager.func_152792_a((MinecraftProfileTexture)loadSkinFromCache.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return DefaultPlayerSkin.func_177334_a((UUID)gameProfile.getId());
    }

    public void render(PlayerStatueEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_77045_g = model;
        if (entityIn.isSlim() && this.field_77045_g != slimModel) {
            this.field_77045_g = slimModel;
        }
        super.func_225623_a_((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void applyRotations(PlayerStatueEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        float f = (float)(entityLiving.field_70170_p.func_82737_E() - entityLiving.punchCooldown) + partialTicks;
        if (f < 5.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_76126_a((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected void preRenderCallback(PlayerStatueEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = 0.9375f;
        matrixStackIn.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }
}

