/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.SheepStatueBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.init.StatueRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;

public class DropHandler {
    private static final Random rand = new Random();

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        Object itemStackToDrop;
        ItemStack itemStackToDrop2;
        Entity entity = event.getEntity();
        Entity source = event.getSource().func_76346_g();
        if (entity instanceof VillagerEntity) {
            switch (entity.field_70170_p.field_73012_v.nextInt(4)) {
                default: {
                    this.dropLootStatues(entity, new ItemStack((IItemProvider)StatueRegistry.VILLAGER_BR_STATUE.get()), source, event);
                    break;
                }
                case 1: {
                    this.dropLootStatues(entity, new ItemStack((IItemProvider)StatueRegistry.VILLAGER_WH_STATUE.get()), source, event);
                    break;
                }
                case 2: {
                    this.dropLootStatues(entity, new ItemStack((IItemProvider)StatueRegistry.VILLAGER_PU_STATUE.get()), source, event);
                    break;
                }
                case 3: {
                    this.dropLootStatues(entity, new ItemStack((IItemProvider)StatueRegistry.VILLAGER_GR_STATUE.get()), source, event);
                    break;
                }
            }
        } else if (entity instanceof EvokerEntity) {
            itemStackToDrop2 = new ItemStack((IItemProvider)StatueRegistry.EVOKER_STATUE.get());
            this.dropLootStatues(entity, itemStackToDrop2, source, event);
        } else if (entity instanceof VindicatorEntity) {
            itemStackToDrop2 = new ItemStack((IItemProvider)StatueRegistry.VINDICATOR_STATUE.get());
            this.dropLootStatues(entity, itemStackToDrop2, source, event);
        } else if (entity instanceof SheepEntity) {
            SheepEntity sheep = (SheepEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.SHEEP_SHAVEN_STATUE.get());
            if (!sheep.func_70892_o()) {
                itemStackToDrop = new ItemStack((IItemProvider)SheepStatueBlock.getStatue(sheep.func_175509_cj()));
            }
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else if (entity instanceof BeeEntity) {
            BeeEntity bee = (BeeEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.BEE_STATUE.get());
            if (entity.field_70170_p.field_73012_v.nextBoolean()) {
                itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.ANGRY_BEE_STATUE.get());
            }
            String trans = "Trans Bee";
            if (bee.func_145748_c_().func_150261_e().equalsIgnoreCase(trans)) {
                itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.BEE_STATUE.get());
                itemStackToDrop.func_200302_a((ITextComponent)new StringTextComponent(trans));
            }
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else if (entity instanceof RabbitEntity) {
            RabbitEntity rabbit = (RabbitEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.RABBIT_BR_STATUE.get());
            switch (rabbit.func_175531_cl()) {
                case 1: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.RABBIT_WH_STATUE.get());
                    break;
                }
                case 2: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.RABBIT_WS_STATUE.get());
                    break;
                }
                case 3: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.RABBIT_BS_STATUE.get());
                    break;
                }
                case 4: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.RABBIT_GO_STATUE.get());
                    break;
                }
                case 5: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.RABBIT_BW_STATUE.get());
                }
            }
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else if (entity instanceof PandaEntity) {
            PandaEntity panda = (PandaEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.PANDA_NORMAL_STATUE.get());
            switch (panda.func_213549_ef()) {
                case AGGRESSIVE: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.PANDA_ANGRY_STATUE.get());
                    break;
                }
                case BROWN: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.PANDA_BROWN_STATUE.get());
                    break;
                }
                case LAZY: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.PANDA_LAZY_STATUE.get());
                    break;
                }
                case PLAYFUL: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.PANDA_PLAYFUL_STATUE.get());
                    break;
                }
                case WEAK: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.PANDA_WEAK_STATUE.get());
                    break;
                }
                case WORRIED: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.PANDA_WORRIED_STATUE.get());
                }
            }
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else if (entity instanceof CatEntity) {
            CatEntity cat = (CatEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_TABBY_STATUE.get());
            switch (cat.func_213413_ef()) {
                case 1: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_TUXEDO_STATUE.get());
                    break;
                }
                case 2: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_RED_STATUE.get());
                    break;
                }
                case 3: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_SIAMESE_STATUE.get());
                    break;
                }
                case 4: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE.get());
                    break;
                }
                case 5: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_CALICO_STATUE.get());
                    break;
                }
                case 6: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_PERSIAN_STATUE.get());
                    break;
                }
                case 7: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_RAGDOLL_STATUE.get());
                    break;
                }
                case 8: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_WHITE_STATUE.get());
                    break;
                }
                case 9: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_JELLIE_STATUE.get());
                    break;
                }
                case 10: {
                    itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.CAT_BLACK_STATUE.get());
                }
            }
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else if (entity instanceof ElderGuardianEntity) {
            itemStackToDrop2 = new ItemStack((IItemProvider)StatueRegistry.ELDER_GUARDIAN_STATUE.get());
            this.dropBossStatue(entity, itemStackToDrop2, source, event);
        } else if (entity instanceof RavagerEntity) {
            itemStackToDrop2 = new ItemStack((IItemProvider)StatueRegistry.RAVAGER_STATUE.get());
            if (rand.nextFloat() <= 0.25f) {
                this.dropBossStatue(entity, itemStackToDrop2, source, event);
            }
        } else if (entity instanceof MooshroomEntity) {
            itemStackToDrop2 = new ItemStack((IItemProvider)StatueRegistry.MOOSHROOM_STATUE.get());
            MooshroomEntity mooshroom = (MooshroomEntity)entity;
            if (mooshroom.func_213444_dV() == MooshroomEntity.Type.BROWN) {
                itemStackToDrop2 = new ItemStack((IItemProvider)StatueRegistry.BROWN_MOOSHROOM_STATUE.get());
            }
            this.dropLootStatues(entity, itemStackToDrop2, source, event);
        } else if (entity instanceof FoxEntity) {
            FoxEntity fox = (FoxEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.FOX_STATUE.get());
            if (fox.func_213471_dV() == FoxEntity.Type.SNOW) {
                itemStackToDrop = new ItemStack((IItemProvider)StatueRegistry.FOX_SNOW_STATUE.get());
            }
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else {
            ArrayList<RegistryObject> matchingStatues = new ArrayList<RegistryObject>();
            for (RegistryObject block : StatueRegistry.BLOCKS.getEntries()) {
                AbstractStatueBase statue;
                if (!(block.get() instanceof AbstractStatueBase) || !(statue = (AbstractStatueBase)block.get()).getEntity().equals((Object)entity.func_200600_R()) || statue.isHiddenStatue()) continue;
                matchingStatues.add(block);
            }
            if (!matchingStatues.isEmpty()) {
                RegistryObject block = (RegistryObject)matchingStatues.get(rand.nextInt(matchingStatues.size()));
                AbstractStatueBase statue = (AbstractStatueBase)block.get();
                ItemStack itemStackToDrop3 = new ItemStack((IItemProvider)statue);
                if (entity instanceof MobEntity) {
                    if (((MobEntity)entity).func_70631_g_() == statue.isBaby()) {
                        this.dropLootStatues(entity, itemStackToDrop3, source, event);
                    }
                } else {
                    this.dropLootStatues(entity, itemStackToDrop3, source, event);
                }
            }
        }
        if (((Boolean)StatuesConfig.COMMON.playerDropsStatue.get()).booleanValue() && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack playerStatueStack = new ItemStack((IItemProvider)StatueRegistry.PLAYER_STATUE.get()).func_200302_a(player.func_200200_C_());
            double random_drop = Math.random();
            double playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get();
            BlockPos entityPos = entity.func_233580_cy_();
            switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.playerStatueKillSource.get())) {
                default: {
                    if (!(source instanceof ServerPlayerEntity) || source instanceof FakePlayer) break;
                    ServerPlayerEntity sourcePlayer = (ServerPlayerEntity)source;
                    List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                    if (!luckyPlayers.isEmpty()) {
                        for (String luckyName : luckyPlayers) {
                            String user = sourcePlayer.func_200200_C_().func_150261_e();
                            if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                            playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get() / 4.0;
                        }
                    }
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), playerStatueStack));
                    break;
                }
                case PLAYER_FAKEPLAYER: {
                    if (!(source instanceof ServerPlayerEntity) || !(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), playerStatueStack));
                    break;
                }
                case ALL: {
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), playerStatueStack));
                }
            }
        }
    }

    public void dropBossStatue(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        BlockPos entityPos = entity.func_233580_cy_();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayerEntity) || source instanceof FakePlayer) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayerEntity)) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
                break;
            }
            case ALL: {
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
            }
        }
    }

    public void dropLootStatues(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        double random_drop = Math.random();
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        BlockPos entityPos = entity.func_233580_cy_();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayerEntity) || source instanceof FakePlayer) break;
                ServerPlayerEntity player = (ServerPlayerEntity)source;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.func_200200_C_().func_150261_e();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayerEntity) || !(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
                break;
            }
            case ALL: {
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
            }
        }
    }
}

