/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.packets;

import com.shynieke.statues.entity.PlayerStatueEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerStatueSyncMessage {
    private UUID entityUUID;
    private CompoundNBT data;

    private PlayerStatueSyncMessage(PacketBuffer buf) {
        this.entityUUID = buf.func_179253_g();
        this.data = buf.func_150793_b();
    }

    public PlayerStatueSyncMessage(UUID playerUUID, CompoundNBT tag) {
        this.entityUUID = playerUUID;
        this.data = tag;
    }

    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.entityUUID);
        buf.func_150786_a(this.data);
    }

    public static PlayerStatueSyncMessage decode(PacketBuffer packetBuffer) {
        return new PlayerStatueSyncMessage(packetBuffer.func_179253_g(), packetBuffer.func_150793_b());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerWorld world;
            Entity entity;
            if (ctx.getDirection().getReceptionSide().isServer() && (entity = (world = ctx.getSender().func_71121_q()).func_217461_a(this.entityUUID)) instanceof PlayerStatueEntity) {
                PlayerStatueEntity playerStatue = (PlayerStatueEntity)entity;
                CompoundNBT entityTag = playerStatue.func_189511_e(new CompoundNBT());
                CompoundNBT entityTagCopy = entityTag.func_74737_b();
                if (!this.data.isEmpty()) {
                    entityTagCopy.func_197643_a(this.data);
                    UUID uuid = playerStatue.func_110124_au();
                    playerStatue.func_70020_e(entityTagCopy);
                    playerStatue.func_184221_a(uuid);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

