/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.SpecialEvaluationI;

public class EvaluatorVisitor
implements ParserVisitor {
    private static final boolean debug = false;
    protected Stack stack = new Stack();
    protected Vector errorList = null;
    protected SymbolTable symTab = null;
    protected boolean errorFlag;

    protected void addToErrorList(String errorStr) {
        if (this.errorList != null) {
            this.errorList.addElement(errorStr);
        }
    }

    public Object getValue(Node topNode, Vector errorList_in, SymbolTable symTab_in) throws Exception {
        if (topNode == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = errorList_in;
        this.symTab = symTab_in;
        this.errorFlag = false;
        this.stack.removeAllElements();
        try {
            topNode.jjtAccept(this, null);
        }
        catch (ParseException e) {
            this.addToErrorList(e.getMessage());
            throw e;
        }
        if (this.errorFlag || this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Error during evaluation");
        }
        return this.stack.pop();
    }

    @Override
    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }

    @Override
    public Object visit(ASTFunNode node, Object data) throws ParseException {
        if (node == null) {
            return null;
        }
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            throw new ParseException("No function class associated with " + node.getName());
        }
        if (pfmc instanceof SpecialEvaluationI) {
            return ((SpecialEvaluationI)((Object)node.getPFMC())).evaluate(node, data, this, this.stack);
        }
        data = node.childrenAccept(this, data);
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        pfmc.run(this.stack);
        return data;
    }

    @Override
    public Object visit(ASTStart node, Object data) throws ParseException {
        throw new ParseException("Start node encountered during evaluation");
    }

    @Override
    public Object visit(ASTVarNode node, Object data) throws ParseException {
        Variable var = node.getVar();
        if (var == null) {
            String message = "Could not evaluate " + node.getName() + ": ";
            throw new ParseException(message + " variable not set");
        }
        Object temp = var.getValue();
        if (temp == null) {
            String message = "Could not evaluate " + node.getName() + ": ";
            throw new ParseException(message + "the variable was not found in the symbol table");
        }
        this.stack.push(temp);
        return data;
    }

    @Override
    public Object visit(SimpleNode node, Object data) throws ParseException {
        throw new ParseException("No visit method for " + node.getClass().toString());
    }
}

