/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.io.StringReader;
import java.util.Vector;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserDumpVisitor;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.ArcCosine;
import org.nfunk.jep.function.ArcCosineH;
import org.nfunk.jep.function.ArcSine;
import org.nfunk.jep.function.ArcSineH;
import org.nfunk.jep.function.ArcTanH;
import org.nfunk.jep.function.ArcTangent;
import org.nfunk.jep.function.ArcTangent2;
import org.nfunk.jep.function.Arg;
import org.nfunk.jep.function.Ceil;
import org.nfunk.jep.function.Clamp;
import org.nfunk.jep.function.ComplexPFMC;
import org.nfunk.jep.function.Cosine;
import org.nfunk.jep.function.CosineH;
import org.nfunk.jep.function.Exp;
import org.nfunk.jep.function.Floor;
import org.nfunk.jep.function.Guassian;
import org.nfunk.jep.function.If;
import org.nfunk.jep.function.Imaginary;
import org.nfunk.jep.function.Logarithm;
import org.nfunk.jep.function.Modulus;
import org.nfunk.jep.function.NaturalLogarithm;
import org.nfunk.jep.function.Polar;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Random;
import org.nfunk.jep.function.Real;
import org.nfunk.jep.function.Sine;
import org.nfunk.jep.function.SineH;
import org.nfunk.jep.function.SquareRoot;
import org.nfunk.jep.function.Str;
import org.nfunk.jep.function.Sum;
import org.nfunk.jep.function.TanH;
import org.nfunk.jep.function.Tangent;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.DoubleNumberFactory;
import org.nfunk.jep.type.NumberFactory;

public class JEP {
    private static final boolean debug = false;
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean allowAssignment;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    protected Parser parser;
    private Node topNode = null;
    protected EvaluatorVisitor ev;
    protected NumberFactory numberFactory;
    protected OperatorSet opSet;

    public JEP() {
        this.traverse = false;
        this.allowUndeclared = false;
        this.allowAssignment = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.opSet = new OperatorSet();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.allowUndeclared = allowUndeclared_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    protected JEP(JEP j) {
        this.traverse = j.traverse;
        this.allowUndeclared = j.allowUndeclared;
        this.allowAssignment = j.allowAssignment;
        this.implicitMul = j.implicitMul;
        this.ev = j.ev;
        this.funTab = j.funTab;
        this.numberFactory = j.numberFactory;
        this.parser = j.parser;
        this.symTab = j.symTab;
        this.errorList = j.errorList;
    }

    public void addComplex() {
        this.symTab.addConstant("i", new Complex(0.0, 1.0));
        this.funTab.put("re", new Real());
        this.funTab.put("im", new Imaginary());
        this.funTab.put("arg", new Arg());
        this.funTab.put("cmod", new Abs());
        this.funTab.put("complex", new ComplexPFMC());
        this.funTab.put("polar", new Polar());
    }

    public void addConstant(String name, Object value) {
        this.symTab.addConstant(name, value);
    }

    public void addFunction(String functionName, PostfixMathCommandI function) {
        this.funTab.put(functionName, function);
    }

    public void addStandardConstants() {
        this.symTab.addConstant("pi", Math.PI);
        this.symTab.addConstant("e", Math.E);
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", new Sine());
        this.funTab.put("cos", new Cosine());
        this.funTab.put("tan", new Tangent());
        this.funTab.put("asin", new ArcSine());
        this.funTab.put("acos", new ArcCosine());
        this.funTab.put("atan", new ArcTangent());
        this.funTab.put("atan2", new ArcTangent2());
        this.funTab.put("sinh", new SineH());
        this.funTab.put("cosh", new CosineH());
        this.funTab.put("tanh", new TanH());
        this.funTab.put("asinh", new ArcSineH());
        this.funTab.put("acosh", new ArcCosineH());
        this.funTab.put("atanh", new ArcTanH());
        this.funTab.put("log", new Logarithm());
        this.funTab.put("ln", new NaturalLogarithm());
        this.funTab.put("exp", new Exp());
        this.funTab.put("sqrt", new SquareRoot());
        this.funTab.put("abs", new Abs());
        this.funTab.put("mod", new Modulus());
        this.funTab.put("sum", new Sum());
        this.funTab.put("ceil", new Ceil());
        this.funTab.put("floor", new Floor());
        this.funTab.put("clamp", new Clamp());
        this.funTab.put("rand", new Random());
        this.funTab.put("guassian", new Guassian());
        this.funTab.put("if", new If());
        this.funTab.put("str", new Str());
    }

    public Double addVariable(String name, double value) {
        Double object = value;
        this.symTab.makeVarIfNeeded(name, object);
        return object;
    }

    public Complex addVariable(String name, double re, double im) {
        Complex object = new Complex(re, im);
        this.symTab.makeVarIfNeeded(name, object);
        return object;
    }

    public void addVariable(String name, Object object) {
        this.symTab.makeVarIfNeeded(name, object);
    }

    public Object evaluate(Node node) throws Exception {
        return this.ev.getValue(node, new Vector(), this.symTab);
    }

    public boolean getAllowAssignment() {
        return this.allowAssignment;
    }

    public boolean getAllowUndeclared() {
        return this.allowUndeclared;
    }

    public Complex getComplexValue() {
        Object value = this.getValueAsObject();
        if (value == null) {
            return null;
        }
        if (value instanceof Complex) {
            return (Complex)value;
        }
        if (value instanceof Number) {
            return new Complex(((Number)value).doubleValue(), 0.0);
        }
        return null;
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            Object str = "";
            for (int i = 0; i < this.errorList.size(); ++i) {
                str = (String)str + this.errorList.elementAt(i) + "\n";
            }
            return str;
        }
        return null;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public boolean getImplicitMul() {
        return this.implicitMul;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    public OperatorSet getOperatorSet() {
        return this.opSet;
    }

    public Parser getParser() {
        return this.parser;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public boolean getTraverse() {
        return this.traverse;
    }

    public double getValue() {
        Object value = this.getValueAsObject();
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Complex) {
            Complex c = (Complex)value;
            if (c.im() != 0.0) {
                return Double.NaN;
            }
            return c.re();
        }
        if (value != null && value instanceof Number) {
            Number n = (Number)value;
            return n.doubleValue();
        }
        return Double.NaN;
    }

    public Object getValueAsObject() {
        if (this.topNode != null && !this.hasError()) {
            Object result;
            try {
                result = this.ev.getValue(this.topNode, this.errorList, this.symTab);
            }
            catch (Exception e) {
                this.errorList.addElement("Error during evaluation");
                return null;
            }
            return result;
        }
        return null;
    }

    public Variable getVar(String name) {
        return this.symTab.getVar(name);
    }

    public Object getVarValue(String name) {
        return this.symTab.getVar(name).getValue();
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void initSymTab() {
        this.symTab = new SymbolTable(new VariableFactory());
    }

    public Node parse(String expression) throws ParseException {
        StringReader sr = new StringReader(expression);
        Node node = this.parser.parseStream(sr, this);
        return node;
    }

    public void parseExpression(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getMessage());
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            try {
                this.topNode.jjtAccept(v, null);
            }
            catch (ParseException e) {
                this.errorList.addElement(e.getMessage());
            }
        }
    }

    public Object removeFunction(String name) {
        return this.funTab.remove(name);
    }

    public Object removeVariable(String name) {
        return this.symTab.remove(name);
    }

    public void setAllowAssignment(boolean value) {
        this.allowAssignment = value;
    }

    public void setAllowUndeclared(boolean value) {
        this.allowUndeclared = value;
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    public boolean setVarValue(String name, Object val) {
        return this.symTab.setVarValue(name, val);
    }
}

