/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Enumeration;
import java.util.Hashtable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;

public class SymbolTable
extends Hashtable {
    protected VariableFactory vf;

    public SymbolTable(VariableFactory varFac) {
        this.vf = varFac;
    }

    public Variable addConstant(String name, Object val) {
        Variable var = this.addVariable(name, val);
        if (var != null) {
            var.setIsConstant(true);
        }
        return var;
    }

    public Variable addVariable(String name, Object val) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            return null;
        }
        var = this.vf.createVariable(name, val);
        super.put(name, var);
        var.setValidValue(true);
        return var;
    }

    public void clearValues() {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Variable var = (Variable)e.nextElement();
            if (var.isConstant()) continue;
            var.setValidValue(false);
        }
    }

    @Override
    @Deprecated
    public Object get(Object key) {
        return this.getValue(key);
    }

    public Object getValue(Object key) {
        Variable var = (Variable)super.get(key);
        if (var == null) {
            return null;
        }
        return var.getValue();
    }

    public Variable getVar(String name) {
        return (Variable)super.get(name);
    }

    public VariableFactory getVariableFactory() {
        return this.vf;
    }

    public Variable makeVarIfNeeded(String name) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            return var;
        }
        var = this.vf.createVariable(name, null);
        super.put(name, var);
        return var;
    }

    public Variable makeVarIfNeeded(String name, Object val) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            var.setValue(val);
            return var;
        }
        var = this.vf.createVariable(name, val);
        super.put(name, var);
        return var;
    }

    @Override
    @Deprecated
    public Object put(Object key, Object val) {
        return this.makeVarIfNeeded((String)key, val);
    }

    public boolean setVarValue(String name, Object val) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            return var.setValue(val);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Variable var = (Variable)e.nextElement();
            sb.append(var.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

