/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class ArcSineH
extends PostfixMathCommand {
    public ArcSineH() {
        this.numberOfParameters = 1;
    }

    public Object asinh(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).asinh();
        }
        if (param instanceof Number) {
            double val = ((Number)param).doubleValue();
            double res = Math.log(val + Math.sqrt(val * val + 1.0));
            return res;
        }
        throw new ParseException("Invalid parameter type");
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.asinh(param));
    }
}

