/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Clamp
extends PostfixMathCommand {
    public Clamp() {
        this.numberOfParameters = 3;
    }

    public boolean gt(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex || param2 instanceof Complex) {
            throw new ParseException("> not defined for complex numbers");
        }
        if (param1 instanceof Number) {
            Number n1 = (Number)param1;
            if (param2 instanceof Number) {
                double y;
                Number n2 = (Number)param2;
                double x = n1.doubleValue();
                return x > (y = n2.doubleValue());
            }
        }
        throw new ParseException("> not defined for object of type " + param1.getClass().getName() + " and " + param1.getClass().getName());
    }

    public boolean lt(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex || param2 instanceof Complex) {
            throw new ParseException("< not defined for complex numbers");
        }
        if (param1 instanceof Number) {
            Number n1 = (Number)param1;
            if (param2 instanceof Number) {
                double y;
                Number n2 = (Number)param2;
                double x = n1.doubleValue();
                return x < (y = n2.doubleValue());
            }
        }
        throw new ParseException("< not defined for object of type " + param1.getClass().getName() + " and " + param1.getClass().getName());
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object value = inStack.pop();
        Object min = inStack.pop();
        Object max = inStack.pop();
        if (this.gt(value, max)) {
            inStack.push(max);
        } else if (this.lt(value, min)) {
            inStack.push(min);
        } else {
            inStack.push(value);
        }
    }
}

