/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.SpecialEvaluationI;
import org.nfunk.jep.type.Complex;

public class If
extends PostfixMathCommand
implements SpecialEvaluationI {
    public If() {
        this.numberOfParameters = -1;
    }

    @Override
    public Object evaluate(Node node, Object data, ParserVisitor pv, Stack inStack) throws ParseException {
        double val;
        int num = node.jjtGetNumChildren();
        if (num < 3 || num > 4) {
            throw new ParseException("If operator must have 3 or 4 arguments.");
        }
        node.jjtGetChild(0).jjtAccept(pv, data);
        this.checkStack(inStack);
        Object condVal = inStack.pop();
        if (condVal instanceof Double) {
            val = (Double)condVal;
        } else if (condVal instanceof Complex) {
            val = ((Complex)condVal).re();
        } else {
            throw new ParseException("Condition in if operator must be double or complex");
        }
        if (val > 0.0) {
            node.jjtGetChild(1).jjtAccept(pv, data);
        } else if (num == 3 || val < 0.0) {
            node.jjtGetChild(2).jjtAccept(pv, data);
        } else {
            node.jjtGetChild(3).jjtAccept(pv, data);
        }
        return data;
    }
}

