/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class NaturalLogarithm
extends PostfixMathCommand {
    public NaturalLogarithm() {
        this.numberOfParameters = 1;
    }

    public Object ln(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).log();
        }
        if (param instanceof Number) {
            double num = ((Number)param).doubleValue();
            if (num > 0.0) {
                return Math.log(num);
            }
            Complex temp = new Complex(num);
            return temp.log();
        }
        throw new ParseException("Invalid parameter type");
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.ln(param));
    }
}

