/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import thut.api.ThutCaps;
import thut.api.entity.IAnimated;

public class AnimatedCaps {
    public static final ResourceLocation WRAP = new ResourceLocation("thutcore:animated_mob");

    private static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        for (ICapabilityProvider p : event.getCapabilities().values()) {
            if (!p.getCapability(ThutCaps.ANIMATED).isPresent()) continue;
            return;
        }
        event.addCapability(WRAP, (ICapabilityProvider)new Impl());
    }

    public static IAnimated getAnimated(ICapabilityProvider in) {
        if (in == null) {
            return null;
        }
        return (IAnimated)in.getCapability(ThutCaps.ANIMATED).orElse(null);
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, EventPriority.LOWEST, AnimatedCaps::attachMobs);
    }

    public static class Impl
    implements IAnimated,
    ICapabilityProvider {
        private final LazyOptional<IAnimated> holder = LazyOptional.of(() -> this);
        protected List<String> anims = Lists.newArrayList();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.ANIMATED.orEmpty(cap, this.holder);
        }

        @Override
        public List<String> getChoices() {
            return this.anims;
        }
    }
}

