/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import thut.api.ThutCaps;

public class LinkableCaps {
    public static void setup() {
        MinecraftForge.EVENT_BUS.addListener(LinkableCaps::linkBlock);
    }

    private static void linkBlock(PlayerInteractEvent.RightClickBlock event) {
        LazyOptional test_tile;
        if (event.getItemStack().m_41619_()) {
            return;
        }
        LazyOptional test_stack = event.getItemStack().getCapability(ThutCaps.STORE);
        if (!test_stack.isPresent()) {
            return;
        }
        ILinkStorage storage = (ILinkStorage)test_stack.orElse(null);
        BlockEntity tile = event.getLevel().m_7702_(event.getPos());
        if (tile != null && (test_tile = tile.getCapability(ThutCaps.LINK, event.getFace())).isPresent()) {
            ((ILinkable)test_tile.orElse(null)).link(storage, (Entity)event.getEntity());
            event.setCanceled(true);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        } else {
            GlobalPos pos = GlobalPos.m_122643_((ResourceKey)event.getEntity().m_9236_().m_46472_(), (BlockPos)event.getPos());
            storage.setLinkedPos(pos, (Entity)event.getEntity());
            event.setCanceled(true);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        }
    }

    public static interface ILinkStorage {
        @Nullable
        public UUID getLinkedMob(Entity var1);

        @Nullable
        public GlobalPos getLinkedPos(Entity var1);

        public boolean setLinkedMob(@Nullable UUID var1, @Nullable Entity var2);

        public boolean setLinkedPos(@Nullable GlobalPos var1, @Nullable Entity var2);
    }

    public static interface ILinkable {
        public boolean link(ILinkStorage var1, @Nullable Entity var2);

        @Nonnull
        public ILinkStorage getLink(@Nullable Entity var1);
    }

    public static class Linkable
    implements ILinkable,
    ICapabilityProvider {
        private final LazyOptional<ILinkable> holder = LazyOptional.of(() -> this);
        LinkStorage store = new LinkStorage();

        @Override
        public boolean link(ILinkStorage link, Entity user) {
            this.store.setLinkedMob(link.getLinkedMob(user), user);
            this.store.setLinkedPos(link.getLinkedPos(user), user);
            return true;
        }

        @Override
        public ILinkStorage getLink(Entity user) {
            return this.store;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.LINK.orEmpty(cap, this.holder);
        }
    }

    public static class LinkStorage
    implements ILinkStorage,
    ICapabilityProvider {
        private final LazyOptional<ILinkStorage> holder = LazyOptional.of(() -> this);
        UUID uuid;
        GlobalPos pos;

        @Override
        public UUID getLinkedMob(Entity user) {
            return this.uuid;
        }

        @Override
        public GlobalPos getLinkedPos(Entity user) {
            return this.pos;
        }

        @Override
        public boolean setLinkedMob(UUID mobid, Entity user) {
            this.uuid = mobid;
            return true;
        }

        @Override
        public boolean setLinkedPos(GlobalPos pos, Entity user) {
            this.pos = pos;
            return true;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.STORE.orEmpty(cap, this.holder);
        }
    }

    public static class PosStorage
    implements ILinkStorage {
        GlobalPos pos;

        @Override
        public UUID getLinkedMob(Entity user) {
            return null;
        }

        @Override
        public GlobalPos getLinkedPos(Entity user) {
            return this.pos;
        }

        @Override
        public boolean setLinkedMob(UUID mobid, Entity user) {
            return false;
        }

        @Override
        public boolean setLinkedPos(GlobalPos pos, Entity user) {
            this.pos = pos;
            return true;
        }
    }
}

