/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import thut.api.IOwnable;
import thut.api.ThutCaps;
import thut.api.block.IOwnableTE;
import thut.api.item.ItemList;
import thut.core.common.ThutCore;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OwnableCaps {
    public static final Set<EntityType<?>> MOBS = Sets.newHashSet();
    public static final Set<BlockEntityType<?>> TILES = Sets.newHashSet();
    public static final ResourceLocation LOCBASE = new ResourceLocation("thutcore:ownable_base");
    public static final ResourceLocation LOCWRAP = new ResourceLocation("thutcore:ownable_wrap");
    public static final ResourceLocation STICKTAG = new ResourceLocation("thutcore:pokeystick");

    public static ICapabilitySerializable<?> makeMobOwnable(Entity mob, boolean nonNull) {
        if (mob instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)mob;
            return new TameWrapper(animal);
        }
        if (mob instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)mob;
            return new HorseWrapper(horse);
        }
        if (MOBS.contains(mob.m_6095_())) {
            return new Impl();
        }
        return nonNull ? new Impl() : null;
    }

    public static IOwnable getOwnable(ICapabilityProvider in) {
        if (in == null) {
            return null;
        }
        return (IOwnable)in.getCapability(ThutCaps.OWNABLE_CAP).orElse(null);
    }

    public static LivingEntity getOwner(LivingEntity target) {
        IOwnable ownable = OwnableCaps.getOwnable((ICapabilityProvider)target);
        if (ownable != null) {
            return ownable.getOwner();
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        for (ICapabilityProvider p : event.getCapabilities().values()) {
            if (!p.getCapability(ThutCaps.OWNABLE_CAP).isPresent()) continue;
            return;
        }
        ICapabilitySerializable<?> own = OwnableCaps.makeMobOwnable((Entity)event.getObject(), false);
        if (own != null) {
            event.addCapability(LOCBASE, own);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void attachTEs(AttachCapabilitiesEvent<BlockEntity> event) {
        for (ICapabilityProvider p : event.getCapabilities().values()) {
            if (!p.getCapability(ThutCaps.OWNABLE_CAP).isPresent()) continue;
            return;
        }
        if (TILES.contains(((BlockEntity)event.getObject()).m_58903_())) {
            event.addCapability(LOCBASE, (ICapabilityProvider)new ImplTE());
        }
    }

    @SubscribeEvent
    public static void onblockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity;
        BlockEntity tile = event.getLevel().m_7702_(event.getPos());
        if (tile != null && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            IOwnable ownable = (IOwnable)tile.getCapability(ThutCaps.OWNABLE_CAP).orElse(null);
            if (ownable instanceof IOwnableTE) {
                IOwnableTE te = (IOwnableTE)ownable;
                te.setPlacer(living);
            } else if (ownable != null) {
                ownable.setOwner(living);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockHit(PlayerInteractEvent.LeftClickBlock event) {
        Level level;
        BlockEntity tile = event.getLevel().m_7702_(event.getPos());
        if (tile != null && (level = tile.m_58904_()) instanceof ServerLevel) {
            IOwnableTE te;
            ServerLevel level2 = (ServerLevel)level;
            IOwnable ownable = (IOwnable)tile.getCapability(ThutCaps.OWNABLE_CAP).orElse(null);
            if (ownable instanceof IOwnableTE && (te = (IOwnableTE)ownable).canEdit((LivingEntity)event.getEntity()) && ItemList.is(STICKTAG, event.getItemStack()) && te.getOwnerId() != null) {
                BlockState state = level2.m_8055_(event.getPos());
                List drops = Block.m_49874_((BlockState)state, (ServerLevel)level2, (BlockPos)event.getPos(), (BlockEntity)tile, (Entity)event.getEntity(), (ItemStack)event.getItemStack());
                if (drops.isEmpty()) {
                    state.onDestroyedByPlayer((Level)level2, event.getPos(), event.getEntity(), true, level2.m_6425_(event.getPos()));
                } else {
                    event.getLevel().m_46961_(event.getPos(), true);
                }
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        IOwnableTE te;
        IOwnable ownable;
        BlockEntity tile = event.getLevel().m_7702_(event.getPos());
        if (tile != null && (ownable = (IOwnable)tile.getCapability(ThutCaps.OWNABLE_CAP).orElse(null)) instanceof IOwnableTE && !(te = (IOwnableTE)ownable).canEdit((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static class TameWrapper
    extends VanillaWrapper<TamableAnimal> {
        LivingEntity owner = null;

        public TameWrapper(TamableAnimal toWrap) {
            super(toWrap);
            this.playerOwned = toWrap.m_21826_() instanceof Player;
            if (!this.playerOwned && toWrap.m_21805_() != null && toWrap.m_20194_() != null) {
                this.playerOwned = toWrap.m_20194_().m_129927_().m_11002_(this.getOwnerId()) != null;
            }
        }

        @Override
        public LivingEntity getOwner() {
            Level level;
            if (this.getOwnerId() == null) {
                this.owner = null;
            }
            if (this.getOwnerId() != null) {
                this.owner = ((TamableAnimal)this.wrapped).m_21826_();
            }
            if (this.getOwnerId() != null && (level = ((TamableAnimal)this.wrapped).m_9236_()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                this.owner = this.getOwner(level2, this.owner);
                return this.owner;
            }
            this.playerOwned = this.owner instanceof Player;
            return this.owner;
        }

        @Override
        public UUID getOwnerId() {
            return ((TamableAnimal)this.wrapped).m_21805_();
        }

        @Override
        public boolean isPlayerOwned() {
            this.playerOwned = this.playerOwned || this.getOwner() instanceof Player;
            return this.playerOwned;
        }

        @Override
        public void setOwner(LivingEntity e) {
            this.setOwner(e == null ? null : e.m_20148_());
            this.owner = e;
            this.playerOwned = e instanceof Player;
        }

        @Override
        public void setOwner(UUID id) {
            ((TamableAnimal)this.wrapped).m_21816_(id);
            ((TamableAnimal)this.wrapped).m_7105_(id != null);
        }
    }

    public static class HorseWrapper
    extends VanillaWrapper<AbstractHorse> {
        LivingEntity owner;

        public HorseWrapper(AbstractHorse toWrap) {
            super(toWrap);
            if (!this.playerOwned && toWrap.m_30615_() != null && toWrap.m_20194_() != null) {
                this.playerOwned = toWrap.m_20194_().m_129927_().m_11002_(this.getOwnerId()) != null;
            }
        }

        @Override
        public LivingEntity getOwner() {
            Level level;
            if (this.getOwnerId() == null) {
                this.owner = null;
            }
            if (this.getOwnerId() != null && this.owner == null && (level = ((AbstractHorse)this.wrapped).m_9236_()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                this.owner = this.getOwner(level2, this.owner);
                return this.owner;
            }
            return this.owner;
        }

        @Override
        public UUID getOwnerId() {
            return ((AbstractHorse)this.wrapped).m_30615_();
        }

        @Override
        public boolean isPlayerOwned() {
            this.playerOwned = this.playerOwned || this.getOwner() instanceof Player;
            return this.playerOwned;
        }

        @Override
        public void setOwner(LivingEntity e) {
            this.owner = e;
            ((AbstractHorse)this.wrapped).m_30586_(e == null ? null : e.m_20148_());
        }

        @Override
        public void setOwner(UUID id) {
            ((AbstractHorse)this.wrapped).m_30586_(id);
        }
    }

    public static class Impl
    extends BaseImpl
    implements IOwnable,
    ICapabilitySerializable<CompoundTag> {
        public void deserializeNBT(CompoundTag nbt) {
            if (nbt.m_128441_("p")) {
                this.playerOwned = nbt.m_128471_("p");
                try {
                    this.ownerId = nbt.m_128342_("o");
                }
                catch (Exception e) {
                    ThutCore.LOGGER.error("Error loading in UUID");
                    this.ownerId = new UUID(nbt.m_128454_("oMost"), nbt.m_128454_("oLeast"));
                }
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.ownerId != null) {
                nbt.m_128362_("o", this.ownerId);
                nbt.m_128379_("p", this.playerOwned);
            }
            return nbt;
        }
    }

    public static class ImplTE
    extends Impl
    implements IOwnableTE {
    }

    public static class BaseImpl
    implements IOwnable,
    ICapabilityProvider {
        final LazyOptional<IOwnable> holder = LazyOptional.of(() -> this);
        UUID ownerId;
        LivingEntity ownerMob;
        boolean playerOwned = false;

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.OWNABLE_CAP.orEmpty(cap, this.holder);
        }

        @Override
        public LivingEntity getOwner() {
            return this.ownerMob;
        }

        @Override
        public UUID getOwnerId() {
            return this.ownerId;
        }

        @Override
        public boolean isPlayerOwned() {
            this.playerOwned = this.playerOwned || this.getOwner() instanceof Player;
            return this.playerOwned;
        }

        @Override
        public void setOwner(LivingEntity e) {
            this.playerOwned = e instanceof Player;
            this.ownerMob = e;
            if (e != null) {
                this.setOwner(e.m_20148_());
            } else {
                this.setOwner((UUID)null);
            }
        }

        @Override
        public void setOwner(UUID id) {
            this.ownerId = id;
        }
    }

    public static abstract class VanillaWrapper<M extends Mob>
    implements IOwnable,
    ICapabilitySerializable<Tag> {
        private final LazyOptional<IOwnable> holder = LazyOptional.of(() -> this);
        boolean playerOwned = false;
        protected final M wrapped;

        public VanillaWrapper(M toWrap) {
            this.wrapped = toWrap;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.OWNABLE_CAP.orEmpty(cap, this.holder);
        }

        public Tag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("p", this.playerOwned);
            return tag;
        }

        public void deserializeNBT(Tag nbt) {
            if (nbt instanceof ByteTag) {
                ByteTag tag = (ByteTag)nbt;
                this.playerOwned = tag.m_7063_() != 0;
            } else if (nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                this.playerOwned = tag.m_128471_("p");
            }
        }
    }
}

