/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import thut.core.common.ThutCore;

public class Tracker {
    private static Tracker INSTANCE = new Tracker();
    private static long start = System.nanoTime();
    private static long n = 0L;
    private static long dt = 0L;
    private static Object2LongArrayMap<Class<?>> taskTimes = new Object2LongArrayMap();
    private static Object2IntArrayMap<Class<?>> taskNs = new Object2IntArrayMap();
    long time = System.currentTimeMillis() / 50L;

    public static Tracker instance() {
        return INSTANCE;
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(Tracker::onServerTick);
        MinecraftForge.EVENT_BUS.addListener(Tracker::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(Tracker::onServerStart);
        MinecraftForge.EVENT_BUS.addListener(Tracker::onWorldSave);
    }

    public static void timerStart() {
        start = System.nanoTime();
    }

    public static void timerEnd(Class<?> involved) {
        long _dt = System.nanoTime() - start;
        dt += _dt;
        taskTimes.compute(involved, (key, value) -> {
            value = value == null ? Long.valueOf(_dt) : Long.valueOf(value + _dt);
            return value;
        });
        taskNs.compute(involved, (key, value) -> {
            value = value == null ? Integer.valueOf(1) : Integer.valueOf(value + 1);
            return value;
        });
        if (++n >= 1000000L) {
            double avg = (double)dt / (double)n;
            System.out.println("Average time: " + avg / 1000.0 + "us");
            System.out.println("class\ttime per\ttime total");
            taskTimes.forEach((clazz, val) -> {
                double avg2 = (double)val.longValue() / (double)taskNs.getInt(clazz);
                String key = "%s\t%.2f\t%.2f";
                System.out.println(key.formatted(clazz, avg2 / 1000.0, (double)val.longValue() / 1000.0));
            });
            taskTimes.clear();
            taskNs.clear();
            n = 0L;
            dt = 0L;
        }
    }

    public long getTick() {
        return this.time;
    }

    private static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++Tracker.instance().time;
        }
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (ServerLifecycleHooks.getCurrentServer() == null && event.phase == TickEvent.Phase.END) {
            ++Tracker.instance().time;
        }
    }

    private static void onServerStart(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        Path path = server.m_129843_(new LevelResource("thutcore"));
        File dir = path.toFile();
        File file = (path = path.resolve("worlddata.dat")).toFile();
        if (!file.exists()) {
            dir.mkdirs();
            return;
        }
        try {
            FileInputStream fileinputstream = new FileInputStream(file);
            CompoundTag CompoundNBT = NbtIo.m_128939_((InputStream)fileinputstream);
            fileinputstream.close();
            CompoundTag tag = CompoundNBT.m_128469_("Data");
            Tracker.read(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void onWorldSave(LevelEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        MinecraftServer server = ThutCore.proxy.getServer();
        Path path = server.m_129843_(new LevelResource("thutcore"));
        File dir = path.toFile();
        File file = (path = path.resolve("worlddata.dat")).toFile();
        if (!file.exists()) {
            dir.mkdirs();
        }
        CompoundTag tag = Tracker.write();
        CompoundTag CompoundNBT1 = new CompoundTag();
        CompoundNBT1.m_128365_("Data", (Tag)tag);
        try {
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            NbtIo.m_128947_((CompoundTag)CompoundNBT1, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void read(CompoundTag nbt) {
        Tracker.instance().time = nbt.m_128454_("tick_timer");
    }

    public static CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("tick_timer", Tracker.instance().time);
        return tag;
    }
}

