/*
 * Decompiled with CFR 0.152.
 */
package thut.api.block.flowing;

import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import thut.api.block.flowing.IFlowingBlock;

public abstract class FlowingBlock
extends Block
implements IFlowingBlock {
    public static final Map<ResourceLocation, RegistryObject<FlowingBlock>> REGMAP = Maps.newHashMap();
    public int tickRateFall = 150;
    public int tickRateFlow = 10;
    protected boolean flows = true;
    private Supplier<Block> convert;

    public static RegistryObject<FlowingBlock>[] makeDust(DeferredRegister<Block> BLOCKS, String modid, String layer, String block, BlockBehaviour.Properties layer_props, BlockBehaviour.Properties block_props) {
        ResourceLocation layer_id = new ResourceLocation(modid, layer);
        ResourceLocation block_id = new ResourceLocation(modid, block);
        RegistryObject[] arr = (RegistryObject[])Array.newInstance(RegistryObject.class, 2);
        RegistryObject layer_reg = BLOCKS.register(layer, () -> new PartialDust(layer_props).alternateBlock(() -> (Block)REGMAP.get(block_id).get()));
        REGMAP.put(layer_id, (RegistryObject<FlowingBlock>)layer_reg);
        RegistryObject block_reg = BLOCKS.register(block, () -> new FullDust(block_props).alternateBlock(() -> (Block)REGMAP.get(layer_id).get()));
        REGMAP.put(block_id, (RegistryObject<FlowingBlock>)block_reg);
        arr[0] = layer_reg;
        arr[1] = block_reg;
        return arr;
    }

    protected FlowingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.initStateDefinition();
    }

    protected void initStateDefinition() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)VISCOSITY, (Comparable)Integer.valueOf(4))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FALLING, (Comparable)Boolean.valueOf(false)));
    }

    public FlowingBlock alternateBlock(Supplier<Block> supplier) {
        this.convert = supplier;
        return this;
    }

    @Override
    public Block getAlternate() {
        return this.convert.get();
    }

    @Override
    public int getFlowRate() {
        return this.tickRateFlow;
    }

    @Override
    public int getFallRate() {
        return this.tickRateFall;
    }

    @Override
    public boolean flows() {
        return this.flows;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
        builder.m_61104_(new Property[]{WATERLOGGED});
        builder.m_61104_(new Property[]{FALLING});
        builder.m_61104_(new Property[]{VISCOSITY});
    }

    public boolean m_6724_(BlockState state) {
        return this.flows(state) && this.isFalling(state);
    }

    public void m_6861_(BlockState us, Level level, BlockPos here, Block other, BlockPos changed, boolean bool) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            this.reScheduleTick(us, slevel, here);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state2, boolean bool) {
        level.m_186460_(pos, (Block)this, this.tickRateFlow);
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            this.updateNearby(pos, slevel, this.tickRateFlow);
        }
    }

    public FluidState m_5888_(BlockState state) {
        if (!state.m_61138_((Property)WATERLOGGED) || !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76191_.m_76145_();
        }
        return Fluids.f_76193_.m_76068_(false);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean flag) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (flag) {
                this.updateNearby(pos, slevel, this.tickRateFlow);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.flows(state)) {
            this.doTick(state, level, pos, random);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_7947_(state, level, pos);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_7947_(state, level, pos);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        boolean falling;
        if (!state.m_61138_((Property)LAYERS)) {
            return Shapes.m_83144_();
        }
        int amt = (Integer)state.m_61143_((Property)LAYERS);
        boolean bl = falling = state.m_61138_((Property)FALLING) && (Boolean)state.m_61143_((Property)FALLING) != false;
        if (falling) {
            return Shapes.m_83040_();
        }
        return SHAPES[amt - 1];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_7947_(state, level, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        BlockState oldState = context.m_43725_().m_8055_(context.m_8083_());
        if (oldState.m_60713_((Block)this) && oldState.m_61138_((Property)LAYERS)) {
            int i = (Integer)oldState.m_61143_((Property)LAYERS);
            return (BlockState)oldState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(16, i + 1)));
        }
        Level levelaccessor = context.m_43725_();
        boolean flag = levelaccessor.m_6425_(blockpos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState state = super.m_5573_(context);
        if (state.m_61138_((Property)WATERLOGGED)) {
            state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (!this.flows(state)) {
            return false;
        }
        int i = this.getAmount(state);
        return i < 16;
    }

    public boolean m_7923_(BlockState p_56630_) {
        return true;
    }

    public static class FullDust
    extends FlowingBlock {
        public FullDust(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Override
        public boolean isFullBlock() {
            return true;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{WATERLOGGED});
            builder.m_61104_(new Property[]{VISCOSITY});
        }

        @Override
        protected void initStateDefinition() {
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
            return Shapes.m_83144_();
        }
    }

    public static class PartialDust
    extends FlowingBlock
    implements SimpleWaterloggedBlock {
        public PartialDust(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

