/*
 * Decompiled with CFR 0.152.
 */
package thut.api.block.flowing;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import thut.api.item.ItemList;
import thut.api.maths.Vector3;
import thut.api.terrain.TerrainChecker;
import thut.core.common.ThutCore;

public interface IFlowingBlock {
    public static final IntegerProperty LAYERS = IntegerProperty.m_61631_((String)"layers", (int)1, (int)16);
    public static final BooleanProperty FALLING = BlockStateProperties.f_61434_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty VISCOSITY = IntegerProperty.m_61631_((String)"viscosity", (int)0, (int)15);
    public static final ResourceLocation DUSTREPLACEABLE = new ResourceLocation("thutcore:dust_replace");
    public static final ResourceLocation NOTDUSTREPLACEABLE = new ResourceLocation("thutcore:no_dust_replace");
    public static final VoxelShape[] SHAPES = IFlowingBlock.makeShapes();

    public static VoxelShape[] makeShapes() {
        VoxelShape[] SHAPES = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            SHAPES[i] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(i + 1), (double)16.0);
        }
        return SHAPES;
    }

    public static BlockState copyValidTo(BlockState from, BlockState to) {
        for (Property p : from.m_61147_()) {
            if (!to.m_61138_(p)) continue;
            to = (BlockState)to.m_61124_(p, from.m_61143_(p));
        }
        return to;
    }

    default public Block thisBlock() {
        return (Block)this;
    }

    public Block getAlternate();

    public int getFlowRate();

    public int getFallRate();

    default public int getSlope(BlockState state) {
        return state.m_61138_((Property)VISCOSITY) ? (Integer)state.m_61143_((Property)VISCOSITY) : 0;
    }

    default public boolean isFullBlock() {
        return false;
    }

    default public boolean flows() {
        return true;
    }

    default public boolean flows(BlockState state) {
        return this.flows();
    }

    default public boolean isFalling(BlockState state) {
        if (!state.m_61138_((Property)FALLING)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)FALLING);
    }

    default public boolean isStableBelow(BlockState state, BlockPos pos, ServerLevel level) {
        IFlowingBlock b;
        Block block;
        int amt = this.getExistingAmount(state, pos, level);
        if (TerrainChecker.isLeaves(state) || TerrainChecker.isWood(state)) {
            return false;
        }
        if (amt == 16 && (block = state.m_60734_()) instanceof IFlowingBlock && (b = (IFlowingBlock)block).isFullBlock() && !b.flows(state)) {
            return true;
        }
        return amt == -1;
    }

    default public BlockState makeFalling(BlockState state, boolean falling) {
        if (this.isFullBlock()) {
            BlockState b = falling ? this.getAlternate().m_49966_() : this.thisBlock().m_49966_();
            b = IFlowingBlock.copyValidTo(state, b);
            if ((b = this.setAmount(b, 16)).m_61138_((Property)FALLING)) {
                b = (BlockState)b.m_61124_((Property)FALLING, (Comparable)Boolean.valueOf(falling));
            }
            return b;
        }
        return (BlockState)state.m_61124_((Property)FALLING, (Comparable)Boolean.valueOf(falling));
    }

    default public BlockState setAmount(BlockState state, int amt) {
        IFlowingBlock b;
        Block block = state.m_60734_();
        if (block instanceof IFlowingBlock && (b = (IFlowingBlock)block) != this) {
            return b.setAmount(state, amt);
        }
        if (!(state.m_60734_() instanceof IFlowingBlock)) {
            return state;
        }
        if (amt == 0) {
            return this.empty(state);
        }
        if (this.isFullBlock()) {
            if (amt == 16) {
                return this.thisBlock().m_49966_();
            }
            b = this.getAlternate().m_49966_();
            b = IFlowingBlock.copyValidTo(state, (BlockState)b);
            return (BlockState)b.m_61124_((Property)LAYERS, Integer.valueOf(amt));
        }
        if (amt == 16 && !this.isFalling(state)) {
            b = this.getAlternate().m_49966_();
            b = IFlowingBlock.copyValidTo(state, (BlockState)b);
            return b;
        }
        return (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(amt));
    }

    default public BlockState empty(BlockState state) {
        if (state.m_61138_((Property)WATERLOGGED) && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76145_().m_76188_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    default public void onStableTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int dust = this.getExistingAmount(state, pos, level);
        if (dust == 16 && state.m_61138_((Property)LAYERS) && this.getAlternate() != this.thisBlock()) {
            level.m_7731_(pos, this.getAlternate().m_49966_(), 2);
        }
    }

    default public BlockState tryFall(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState fall;
        boolean falling = this.isFalling(state);
        int dust = this.getExistingAmount(state, pos, level);
        BlockPos belowPos = pos.m_7495_();
        BlockState b = level.m_8055_(belowPos);
        int below = this.getExistingAmount(b, belowPos, level);
        boolean belowFalling = this.isFalling(b);
        if (!this.canReplace(b)) {
            boolean shouldBeFalling;
            int dustBelow = this.getAmount(b);
            FluidState us = state.m_60819_();
            FluidState belowFluid = level.m_6425_(belowPos);
            boolean fluidCheck = us.m_205074_().m_203334_() != belowFluid.m_205074_().m_203334_();
            boolean bl = shouldBeFalling = belowFalling || (fluidCheck &= !level.m_6425_(belowPos).m_76178_()) || dustBelow < 16 && dustBelow > 0;
            if (shouldBeFalling && !falling) {
                BlockState fall2 = this.makeFalling(state, true);
                if (fall2 != state) {
                    state = fall2;
                    level.m_7731_(pos, state, 2);
                    level.m_186460_(pos.m_7949_(), this.thisBlock(), this.getFallRate());
                    return state;
                }
            } else if (!shouldBeFalling && falling) {
                BlockState fall3 = this.makeFalling(state, false);
                if (fall3 != state) {
                    state = fall3;
                    level.m_7731_(pos, state, 2);
                }
                return state;
            }
        }
        if (falling || !state.m_61138_((Property)FALLING)) {
            if (below < 0 || below == 16) {
                if (!belowFalling) {
                    state = this.makeFalling(state, false);
                    level.m_7731_(pos, state, 2);
                    return state;
                }
            } else {
                int total = dust + below;
                int diff = 16 - below;
                if (total <= 16) {
                    newBelow = this.getMergeResult(this.setAmount(state, total), b, belowPos, level);
                    if (newBelow != b) {
                        int aH;
                        state = this.setAmount(state, 0);
                        int aB = this.getAmount(newBelow);
                        if (aB + (aH = this.getAmount(state)) != total) {
                            ThutCore.LOGGER.error("Error falling down {}, fluid not conserved!", (Object)this);
                        }
                        level.m_7731_(belowPos, newBelow, 2);
                        level.m_186460_(belowPos, newBelow.m_60734_(), this.getFallRate());
                        level.m_7731_(pos, state, 2);
                        return state;
                    }
                } else if (dust - diff >= 0) {
                    BlockState b2 = this.getAlternate().m_49966_();
                    newBelow = this.getMergeResult(b2 = IFlowingBlock.copyValidTo(state, b2), b, belowPos, level);
                    if (newBelow != b) {
                        int aH;
                        newBelow = this.setAmount(newBelow, 16);
                        state = this.setAmount(state, dust - diff);
                        int aB = this.getAmount(newBelow);
                        if (aB + (aH = this.getAmount(state)) != total) {
                            ThutCore.LOGGER.error("Error merging down {}, fluid not conserved!", (Object)this);
                        }
                        level.m_7731_(belowPos, newBelow, 2);
                        level.m_7731_(pos, state, 2);
                        level.m_186460_(pos.m_7949_(), this.thisBlock(), this.getFallRate());
                        level.m_186460_(belowPos, newBelow.m_60734_(), this.getFallRate());
                        return state;
                    }
                }
            }
        }
        if (below >= 0 && below < 16 && (fall = this.makeFalling(state, true)) != state) {
            state = fall;
            level.m_7731_(pos, state, 2);
            level.m_186460_(pos.m_7949_(), this.thisBlock(), this.getFallRate());
        }
        return state;
    }

    default public BlockState trySpread(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int slope;
        int dust = this.getExistingAmount(state, pos, level);
        if (dust >= (slope = this.getSlope(state))) {
            Vector3 v = new Vector3().set(pos);
            BlockState b = null;
            Direction dir = null;
            int existing = dust;
            int amt = 0;
            int rng = random.m_188503_(100);
            for (int i = 0; i < Direction.values().length; ++i) {
                int index = (i + rng) % Direction.values().length;
                Direction d = Direction.values()[index];
                if (d == Direction.DOWN || d == Direction.UP) continue;
                v.set(d).addTo(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                b = v.getBlockState((BlockGetter)level);
                amt = this.getExistingAmount(b, v.getPos(), level);
                if (amt == -1 || amt > dust - slope) continue;
                existing += amt;
                dir = d;
                break;
            }
            if (dir != null && amt != dust) {
                int left = existing;
                int next = 0;
                next = (existing - slope) / 2;
                left = existing - next;
                if (slope == 0 && dust > 1 && left - next == 1) {
                    int tmp = left;
                    left = next;
                    next = tmp;
                }
                if (next > 0 && left != dust) {
                    BlockState oldState = this.setAmount(state, left);
                    BlockPos pos2 = v.getPos();
                    BlockState nextState = this.setAmount(state, next);
                    BlockState newState = this.getMergeResult(nextState, b, pos2, level);
                    if (newState != b) {
                        int aH;
                        int aB = this.getAmount(newState);
                        if (aB + (aH = this.getAmount(oldState)) != existing) {
                            ThutCore.LOGGER.error("Error falling down {}, fluid not conserved!", (Object)this);
                        }
                        level.m_7731_(pos, oldState, 2);
                        level.m_7731_(pos2, newState, 2);
                        level.m_186460_(pos.m_7949_(), oldState.m_60734_(), this.getFlowRate());
                        level.m_186460_(pos2, newState.m_60734_(), this.getFlowRate());
                        return newState;
                    }
                }
            }
        }
        return state;
    }

    default public int getExistingAmount(BlockState state, BlockPos pos, ServerLevel level) {
        return this.getAmount(state);
    }

    default public int getAmount(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IFlowingBlock) {
            IFlowingBlock b = (IFlowingBlock)block;
            if (b != this) {
                return b.getAmount(state);
            }
            if (b.isFullBlock()) {
                return 16;
            }
            return state.m_61138_((Property)LAYERS) ? (Integer)state.m_61143_((Property)LAYERS) : (b.flows(state) ? 16 : -1);
        }
        return this.canReplace(state) ? 0 : -1;
    }

    default public boolean canReplace(BlockState state, BlockPos pos, ServerLevel level) {
        return this.canReplace(state);
    }

    default public boolean canReplace(BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (ItemList.is(NOTDUSTREPLACEABLE, state)) {
            return false;
        }
        if (state.m_60722_((Fluid)Fluids.f_76192_)) {
            return true;
        }
        return ItemList.is(DUSTREPLACEABLE, state);
    }

    default public BlockState getMergeResult(BlockState mergeFrom, BlockState mergeInto, BlockPos posTo, ServerLevel level) {
        FluidState into = mergeInto.m_60819_();
        if ((into.m_192917_((Fluid)Fluids.f_76193_) || mergeInto.m_61138_((Property)WATERLOGGED) && ((Boolean)mergeInto.m_61143_((Property)WATERLOGGED)).booleanValue()) && mergeFrom.m_61138_((Property)WATERLOGGED)) {
            mergeFrom = (BlockState)mergeFrom.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        if (this.canMergeInto(mergeFrom, mergeInto, posTo, level)) {
            return mergeFrom;
        }
        return mergeInto;
    }

    default public boolean canMergeInto(BlockState here, BlockState other, BlockPos posTo, ServerLevel level) {
        return this.canReplace(other, posTo, level) || other.m_60734_() == here.m_60734_();
    }

    default public void updateNearby(BlockPos centre, ServerLevel level, int tickRate) {
    }

    default public void reScheduleTick(BlockState state, ServerLevel level, BlockPos pos) {
        if (!level.m_183326_().m_183588_(pos, (Object)state.m_60734_()) && state.m_60823_()) {
            level.m_186460_(pos, state.m_60734_(), this.isFalling(state) ? this.getFallRate() : this.getFlowRate());
        }
    }

    default public void doTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.flows(state)) {
            return;
        }
        boolean debug = false;
        if (debug) {
            level.m_46473_().m_6180_("flowing_block:" + this.getClass());
        }
        int amt = this.getAmount(state);
        if (debug) {
            level.m_46473_().m_6180_("fall_check");
        }
        BlockState rem = this.tryFall(state, level, pos, random);
        if (debug) {
            level.m_46473_().m_7238_();
        }
        if (debug) {
            level.m_46473_().m_6180_("spread_check");
        }
        if (this.getAmount(rem) > 0) {
            rem = this.trySpread(rem, level, pos, random);
        }
        if (debug) {
            level.m_46473_().m_6180_("stability_check:" + this.getClass());
        }
        if (this.getAmount(rem) == amt) {
            this.onStableTick(rem, level, pos, random);
        } else if (this.getAmount(rem) > 0) {
            this.reScheduleTick(rem, level, pos);
        }
        if (debug) {
            level.m_46473_().m_7238_();
        }
        if (debug) {
            level.m_46473_().m_7238_();
        }
    }
}

