/*
 * Decompiled with CFR 0.152.
 */
package thut.api.block.flowing;

import java.lang.reflect.Array;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import thut.api.block.flowing.FlowingBlock;
import thut.api.block.flowing.IFlowingBlock;
import thut.api.block.flowing.SolidBlock;
import thut.api.item.ItemList;
import thut.api.terrain.TerrainChecker;
import thut.core.common.ThutCore;

public abstract class MoltenBlock
extends FlowingBlock
implements SimpleWaterloggedBlock {
    public static final ResourceLocation LAVAREPLACEABLE = new ResourceLocation("thutcore:lava_replace");
    public static final BooleanProperty HEATED = BooleanProperty.m_61465_((String)"heated");
    Supplier<Block> solid;
    public float hardenRate = 1.0f;
    protected BlockState solid_full = null;
    protected BlockState solid_layer = null;

    public static RegistryObject<FlowingBlock>[] makeMolten(DeferredRegister<Block> BLOCKS, String modid, String layer, String block, BlockBehaviour.Properties layer_props, BlockBehaviour.Properties block_props, ResourceLocation solid_layer, ResourceLocation solid_block) {
        ResourceLocation layer_id = new ResourceLocation(modid, layer);
        ResourceLocation block_id = new ResourceLocation(modid, block);
        RegistryObject[] arr = (RegistryObject[])Array.newInstance(RegistryObject.class, 2);
        RegistryObject layer_reg = BLOCKS.register(layer, () -> new PartialMolten(layer_props).solidBlock(() -> (Block)((RegistryObject)SolidBlock.REGMAP.get(solid_layer)).get()).alternateBlock(() -> (Block)((RegistryObject)REGMAP.get(block_id)).get()));
        REGMAP.put(layer_id, layer_reg);
        RegistryObject block_reg = BLOCKS.register(block, () -> new FullMolten(block_props).solidBlock(() -> (Block)((RegistryObject)SolidBlock.REGMAP.get(solid_block)).get()).alternateBlock(() -> (Block)((RegistryObject)REGMAP.get(layer_id)).get()));
        REGMAP.put(block_id, block_reg);
        arr[0] = layer_reg;
        arr[1] = block_reg;
        return arr;
    }

    protected MoltenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.tickRateFall = 5;
        this.tickRateFlow = 5;
    }

    @Override
    protected void initStateDefinition() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(16))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FALLING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VISCOSITY, (Comparable)Integer.valueOf(4)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEATED});
    }

    public RenderShape m_7514_(BlockState state) {
        if (this.isFalling(state)) {
            return RenderShape.MODEL;
        }
        return RenderShape.INVISIBLE;
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return true;
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        int amt = this.getAmount(state);
        if (amt > 12) {
            level.m_7731_(pos, this.empty(state), 3);
            if (!state.m_60710_((LevelReader)level, pos)) {
                level.m_46961_(pos, true);
            }
            return new ItemStack((ItemLike)Items.f_42448_);
        }
        return super.m_142598_(level, pos, state);
    }

    public MoltenBlock solidBlock(Supplier<Block> supplier) {
        this.solid = supplier;
        return this;
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        if (this.isFalling(state)) {
            return Fluids.f_76191_.m_76145_();
        }
        int amt = this.getAmount(state);
        if (amt < 2) {
            amt = 2;
        }
        return (FluidState)Fluids.f_76194_.m_76145_().m_61124_((Property)FlowingFluid.f_75948_, (Comparable)Integer.valueOf(amt / 2));
    }

    @Override
    public VoxelShape m_5939_(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Shapes.m_83040_();
    }

    @Override
    public boolean canReplace(BlockState state, BlockPos pos, ServerLevel level) {
        if (super.canReplace(state, pos, level)) {
            return true;
        }
        return state.isFlammable((BlockGetter)level, pos, Direction.UP);
    }

    @Override
    public boolean canReplace(BlockState state) {
        boolean burns;
        if (ItemList.is(LAVAREPLACEABLE, state)) {
            return true;
        }
        boolean bl = burns = ((FireBlock)Blocks.f_50083_).m_221164_(state) > 0;
        if (burns) {
            return true;
        }
        return super.canReplace(state);
    }

    @Override
    public BlockState setAmount(BlockState state, int amt) {
        boolean hot = state.m_61138_((Property)HEATED) && (Boolean)state.m_61143_((Property)HEATED) != false;
        BlockState ret = super.setAmount(state, amt);
        if (hot && ret.m_61138_((Property)HEATED)) {
            ret = (BlockState)ret.m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(hot));
        }
        return ret;
    }

    @Override
    public BlockState getMergeResult(BlockState mergeFrom, BlockState mergeInto, BlockPos posTo, ServerLevel level) {
        BlockState ret = super.getMergeResult(mergeFrom, mergeInto, posTo, level);
        if (ret != mergeInto && ret.m_61138_((Property)HEATED)) {
            ret = (BlockState)ret.m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(false));
        }
        return ret;
    }

    @Override
    public boolean canMergeInto(BlockState here, BlockState other, BlockPos posTo, ServerLevel level) {
        int amt_to;
        int amt_from;
        IFlowingBlock to;
        this.checkSolid();
        if (this.solid_full.m_60795_()) {
            return false;
        }
        IFlowingBlock iFlowingBlock = to = other.m_60734_() instanceof FlowingBlock ? (IFlowingBlock)other.m_60734_() : null;
        if ((other.m_60734_() == this.solid_layer.m_60734_() || to != null && to.getAlternate() == this.solid_layer.m_60734_()) && (amt_from = this.getAmount(here)) != (amt_to = this.getAmount(other))) {
            return true;
        }
        return super.canMergeInto(here, other, posTo, level);
    }

    @Override
    public boolean isStableBelow(BlockState state, BlockPos pos, ServerLevel level) {
        Block block;
        int amt = this.getExistingAmount(state, pos, level);
        if (TerrainChecker.isLeaves(state) || TerrainChecker.isWood(state)) {
            return false;
        }
        if (amt == 16 && (block = state.m_60734_()) instanceof IFlowingBlock) {
            IFlowingBlock b = (IFlowingBlock)block;
            if (b.isFullBlock() && !b.flows(state)) {
                return true;
            }
            if (state.m_61138_((Property)HEATED) && ((Boolean)state.m_61143_((Property)HEATED)).booleanValue()) {
                return true;
            }
        }
        return amt == -1;
    }

    @Override
    public void onStableTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!FMLEnvironment.production) {
            this.tickRateFall = 1;
            this.tickRateFlow = 1;
        }
        double rng = random.m_188500_();
        if (!(state.m_61138_((Property)HEATED) && ((Boolean)state.m_61143_((Property)HEATED)).booleanValue() || !(rng < (double)this.hardenRate) || this.isFalling(state))) {
            this.checkSolid();
            if (!this.solid_full.m_60795_()) {
                boolean stableBelow = false;
                BlockPos p2 = pos.m_7495_();
                BlockState b2 = level.m_8055_(p2);
                stableBelow = this.isStableBelow(b2, p2, level);
                if (stableBelow) {
                    int dust = this.getExistingAmount(state, pos, level);
                    BlockState solidTo = this.solid_full;
                    if (dust != 16) {
                        solidTo = this.solid_layer;
                    }
                    solidTo = IFlowingBlock.copyValidTo(state, solidTo);
                    solidTo = this.setAmount(solidTo, dust);
                    level.m_7731_(pos, solidTo, 2);
                    this.onHarden(state, solidTo, level, pos, random);
                    return;
                }
            }
        } else if (rng > (double)this.hardenRate) {
            this.reScheduleTick(state, level, pos);
            return;
        }
        super.onStableTick(state, level, pos, random);
        if (state.m_60739_((BlockGetter)level, pos) != 0) {
            level.m_46865_(pos).m_8092_(false);
        }
    }

    protected void onHarden(BlockState state, BlockState solidTo, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    protected void checkSolid() {
        if (this.solid_layer == null) {
            Block block = this.solid.get();
            if (!(block instanceof FlowingBlock)) {
                this.solid_full = Blocks.f_50016_.m_49966_();
                return;
            }
            FlowingBlock b = (FlowingBlock)block;
            BlockState s = b.m_49966_();
            if (s.m_61138_((Property)LAYERS)) {
                this.solid_layer = s;
                this.solid_full = b.getAlternate().m_49966_();
                if (this.solid_full.m_61138_((Property)LAYERS)) {
                    ThutCore.LOGGER.error((Object)new IllegalStateException("This should not be the case!"));
                    this.solid_full = Blocks.f_50016_.m_49966_();
                    return;
                }
            } else {
                this.solid_full = s;
                this.solid_layer = b.getAlternate().m_49966_();
                if (!this.solid_layer.m_61138_((Property)LAYERS)) {
                    ThutCore.LOGGER.error((Object)new IllegalStateException("This should not be the case!"));
                    this.solid_full = Blocks.f_50016_.m_49966_();
                    return;
                }
            }
        }
    }

    public static class FullMolten
    extends MoltenBlock {
        public FullMolten(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Override
        public boolean isFullBlock() {
            return true;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{WATERLOGGED});
            builder.m_61104_(new Property[]{HEATED});
            builder.m_61104_(new Property[]{VISCOSITY});
        }

        @Override
        protected void initStateDefinition() {
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HEATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VISCOSITY, (Comparable)Integer.valueOf(4)));
        }

        @Override
        public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
            return Shapes.m_83144_();
        }
    }

    public static class PartialMolten
    extends MoltenBlock {
        public PartialMolten(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

