/*
 * Decompiled with CFR 0.152.
 */
package thut.api.block.flowing;

import java.lang.reflect.Array;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import thut.api.block.flowing.FlowingBlock;

public abstract class SolidBlock
extends FlowingBlock {
    public static RegistryObject<FlowingBlock>[] makeSolid(DeferredRegister<Block> BLOCKS, String modid, String layer, String block, BlockBehaviour.Properties layer_props, BlockBehaviour.Properties block_props) {
        ResourceLocation layer_id = new ResourceLocation(modid, layer);
        ResourceLocation block_id = new ResourceLocation(modid, block);
        RegistryObject[] arr = (RegistryObject[])Array.newInstance(RegistryObject.class, 2);
        RegistryObject layer_reg = BLOCKS.register(layer, () -> new PartialSolid(layer_props).alternateBlock(() -> (Block)((RegistryObject)REGMAP.get(block_id)).get()));
        REGMAP.put(layer_id, layer_reg);
        RegistryObject block_reg = BLOCKS.register(block, () -> new FullSolid(block_props).alternateBlock(() -> (Block)((RegistryObject)REGMAP.get(layer_id)).get()));
        REGMAP.put(block_id, block_reg);
        arr[0] = layer_reg;
        arr[1] = block_reg;
        return arr;
    }

    protected SolidBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.flows = false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
        builder.m_61104_(new Property[]{WATERLOGGED});
        builder.m_61104_(new Property[]{VISCOSITY});
    }

    @Override
    protected void initStateDefinition() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VISCOSITY, (Comparable)Integer.valueOf(4)));
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return false;
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    public static class FullSolid
    extends SolidBlock {
        public FullSolid(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Override
        public boolean isFullBlock() {
            return true;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{VISCOSITY});
        }

        @Override
        protected void initStateDefinition() {
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VISCOSITY, (Comparable)Integer.valueOf(4)));
        }

        @Override
        public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
            return Shapes.m_83144_();
        }
    }

    public static class PartialSolid
    extends SolidBlock
    implements SimpleWaterloggedBlock {
        public PartialSolid(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

