/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import thut.api.boom.ExplosionCustom;

public abstract class AbstractChecker {
    protected final ExplosionCustom boom;
    public long totalTime = 0L;
    public long realTotalTime = 0L;
    private long start;
    private long nanoS;

    public AbstractChecker(ExplosionCustom boom) {
        this.boom = boom;
    }

    protected void start() {
        this.realTotalTime = System.nanoTime();
    }

    protected void beginLoop() {
        this.start = System.currentTimeMillis();
        this.nanoS = System.nanoTime();
    }

    protected void endLoop() {
        this.totalTime += System.nanoTime() - this.nanoS;
    }

    protected boolean canContinue() {
        return System.currentTimeMillis() - this.start < (long)this.boom.maxPerTick;
    }

    protected abstract ExplosionCustom.BlastResult getBlocksToRemove();

    protected abstract void printDebugInfo();
}

