/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.boom.AbstractChecker;
import thut.api.boom.ShadowMaskChecker;
import thut.api.boom.SphereMaskChecker;
import thut.api.item.ItemList;
import thut.api.maths.Vector3;
import thut.api.terrain.TerrainManager;
import thut.core.common.ThutCore;

public class ExplosionCustom
extends Explosion {
    public static int MAX_RADIUS = 127;
    public static int MAXPERTICK = 25;
    public static float MINBLASTDAMAGE = 0.1f;
    public static boolean AFFECTINAIR = true;
    public static final ResourceLocation EXPLOSION_BLOCKING = new ResourceLocation("thutcore:explosion_blocking");
    public static final ResourceLocation EXPLOSION_TRANSPARENT = new ResourceLocation("thutcore:explosion_transparent");
    public static final ResourceLocation EXPLOSION_2X_WEAK = new ResourceLocation("thutcore:explosion_2x_weaker");
    public static final ResourceLocation EXPLOSION_10X_WEAK = new ResourceLocation("thutcore:explosion_10x_weaker");
    public IEntityHitter hitter = (e, power, boom) -> {
        EntityDimensions size = e.m_6972_(e.m_20089_());
        float area = size.f_20377_ * size.f_20378_;
        float damage = area * power;
        if (!e.m_20147_()) {
            e.m_6469_(DamageSource.m_19358_((Explosion)boom), damage);
        }
    };
    float minBlastDamage;
    int f_46017_ = MAX_RADIUS;
    public int maxPerTick;
    public ServerLevel f_46012_;
    Vector3 centre;
    final float strength;
    public BlockBreaker breaker;
    public ShadowMaskChecker.ResistProvider resistProvider = new ShadowMaskChecker.ResistProvider(){};
    public Player owner = null;
    List<Entity> targets = new ArrayList<Entity>();
    public float factor = 150.0f;
    Entity exploder;
    List<ExplosionCustom> subBooms = new ArrayList<ExplosionCustom>();
    boolean hasSubBooms = false;
    boolean boomDone = false;
    private AbstractChecker boomApplier;

    public ExplosionCustom(ServerLevel world, Entity par2Entity, double x, double y, double z, float power) {
        this(world, par2Entity, new Vector3().set(x, y, z), power);
    }

    public ExplosionCustom(ServerLevel world, Entity par2Entity, Vector3 center, float power2) {
        super((Level)world, par2Entity, null, null, center.x, center.y, center.z, power2, false, Explosion.BlockInteraction.DESTROY);
        this.f_46012_ = world;
        this.exploder = par2Entity;
        this.centre = center.copy();
        this.minBlastDamage = MINBLASTDAMAGE;
        this.maxPerTick = MAXPERTICK;
        this.strength = this.factor * power2;
        this.boomApplier = new SphereMaskChecker(this);
        this.breaker = new DefaultBreaker(world);
    }

    private void applyBlockEffects(BlastResult result) {
        this.m_46081_().clear();
        this.breaker.destroyBlocks(result, this);
        this.breaker.damageBlocks(result, this);
    }

    private void applyEntityEffects(BlastResult result) {
        this.targets.clear();
        for (HitEntity e : result.hit) {
            Entity hit = e.entity;
            float power = e.blastStrength;
            if (!(power > 0.0f)) continue;
            this.hitter.hitEntity(hit, power, this);
            this.targets.add(hit);
        }
    }

    public boolean canBreak(Vector3 location, BlockState state) {
        boolean ret;
        boolean bl = ret = !ItemList.is(EXPLOSION_BLOCKING, state);
        if (!ret) {
            return false;
        }
        if (this.owner != null) {
            try {
                BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent((Level)this.f_46012_, location.getPos(), state, this.owner);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (evt.isCanceled()) {
                    return false;
                }
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error checking if we can break a block!");
                ThutCore.LOGGER.error((Object)e);
                return false;
            }
        }
        return true;
    }

    public void doExplosion() {
        this.f_46012_.m_6263_((Player)null, this.centre.x, this.centre.y, this.centre.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_46012_.f_46441_.m_188501_() - this.f_46012_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.centre.x, this.centre.y, this.centre.z, 1.0, 0.0, 0.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.boomApplier.start();
        if (this.hasSubBooms) {
            this.subBooms.get(0).doExplosion();
        }
    }

    public void m_46061_() {
        ThutCore.LOGGER.error("This should not be run anymore", (Throwable)new Exception());
    }

    public void m_46075_(boolean par1) {
        ThutCore.LOGGER.error("This should not be run anymore", (Throwable)new Exception());
    }

    public void doKineticImpactor(ServerLevel world, Vector3 velocity, Vector3 hitLocation, Vector3 acceleration, float density, float energy) {
        if (density < 0.0f || energy <= 0.0f) {
            return;
        }
        this.factor = 1.0f;
        int max = 63;
        if (acceleration == null) {
            acceleration = Vector3.empty;
        }
        int n = 0;
        ArrayList<Vector3> locations = new ArrayList<Vector3>();
        ArrayList<Float> blasts = new ArrayList<Float>();
        float resist = hitLocation.getExplosionResistance(this, (LevelReader)world);
        float blast = Math.min(energy * (resist / density), energy);
        if (resist > density) {
            hitLocation = hitLocation.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(world, this.exploder, hitLocation, blast * this.factor);
            boo.setMaxRadius(this.f_46017_);
            boo.breaker = this.breaker;
            boo.owner = this.owner;
            boo.doExplosion();
            return;
        }
        Vector3 absorbedLoc = new Vector3();
        float remainingEnergy = 0.0f;
        density -= resist;
        while (energy > 0.0f && density > 0.0f) {
            locations.add(hitLocation.subtract(velocity.normalize()));
            blasts.add(Float.valueOf(blast));
            hitLocation = hitLocation.add(velocity.normalize());
            velocity.add(acceleration);
            resist = Math.max(hitLocation.getExplosionResistance(this, (LevelReader)world), 0.0f);
            blast = Math.min(energy * (resist / density), energy);
            if (resist > density) {
                absorbedLoc.set(hitLocation);
                remainingEnergy = energy;
                break;
            }
            energy -= energy * (resist / density);
            density = (float)((double)density - ((double)resist + 0.1));
        }
        if ((n = locations.size()) != 0) {
            for (int i = 0; i < n; ++i) {
                Vector3 source = (Vector3)locations.get(i);
                float strength = Math.min(((Float)blasts.get(i)).floatValue(), 256.0f);
                if (!TerrainManager.isAreaLoaded((LevelAccessor)world, source.getPos(), 63.0) || strength == 0.0f) continue;
                ExplosionCustom boo = new ExplosionCustom(world, this.exploder, source, strength * this.factor);
                boo.setMaxRadius(this.f_46017_);
                boo.breaker = this.breaker;
                boo.owner = this.owner;
                this.subBooms.add(boo);
                this.hasSubBooms = true;
            }
        }
        if (remainingEnergy > 10.0f) {
            absorbedLoc = absorbedLoc.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(world, this.exploder, absorbedLoc, remainingEnergy * this.factor);
            boo.setMaxRadius(this.f_46017_);
            boo.breaker = this.breaker;
            boo.owner = this.owner;
            this.subBooms.add(boo);
            this.hasSubBooms = true;
        }
        this.doExplosion();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void doRemoveBlocks(TickEvent.LevelTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START || evt.level != this.f_46012_) {
            return;
        }
        if (this.hasSubBooms) {
            if (this.subBooms.isEmpty()) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                this.boomDone = true;
            } else {
                ExplosionCustom boom = this.subBooms.get(0);
                if (boom.boomDone) {
                    this.subBooms.remove(0);
                    if (this.subBooms.size() > 0) {
                        this.subBooms.get(0).doExplosion();
                    }
                }
            }
            return;
        }
        long dt = this.f_46012_.m_7654_().m_129932_() - Util.m_137550_();
        this.maxPerTick = Math.min((int)dt / 2, MAXPERTICK);
        this.m_46080_();
        BlastResult result = this.boomApplier.getBlocksToRemove();
        this.applyBlockEffects(result);
        this.applyEntityEffects(result);
        ExplosionEvent.Detonate evt2 = new ExplosionEvent.Detonate((Level)this.f_46012_, (Explosion)this, this.targets);
        MinecraftForge.EVENT_BUS.post((Event)evt2);
        for (ChunkPos pos : result.affectedChunks) {
            LevelChunk chunk = this.f_46012_.m_7726_().m_7131_(pos.f_45578_, pos.f_45579_);
            if (chunk == null) continue;
            chunk.m_8092_(false);
        }
        if (result.done) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.boomApplier.printDebugInfo();
            this.boomDone = true;
        }
    }

    public ExplosionCustom setMaxRadius(int radius) {
        this.f_46017_ = radius;
        return this;
    }

    @SubscribeEvent
    public void WorldUnloadEvent(LevelEvent.Unload evt) {
        if (evt.getLevel() == this.f_46012_) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public static interface IEntityHitter {
        public void hitEntity(Entity var1, float var2, Explosion var3);
    }

    public static class DefaultBreaker
    implements BlockBreaker {
        public static final ResourceLocation DAMAGE_LIST = new ResourceLocation("thutcore:absorption_damage");
        final ServerLevel level;
        final StructureProcessorList list;
        final StructurePlaceSettings settings;

        public DefaultBreaker(ServerLevel level) {
            this.level = level;
            this.list = (StructureProcessorList)level.m_5962_().m_175515_(Registry.f_122883_).m_7745_(DAMAGE_LIST);
            this.settings = new StructurePlaceSettings();
        }

        @Override
        public BlockState onAbsorbed(ExplosionCustom boom, BlockPos pos, BlockState state, float power, boolean canEffect, ServerLevel level) {
            StructureTemplate.StructureBlockInfo info;
            if (!canEffect) {
                return state;
            }
            StructureTemplate.StructureBlockInfo processed = info = new StructureTemplate.StructureBlockInfo(pos, state, null);
            for (StructureProcessor list : this.list.m_74425_()) {
                info = list.process((LevelReader)level, pos, pos, info, processed, this.settings, null);
            }
            if (state != info.f_74676_) {
                state = info.f_74676_;
                level.m_7731_(pos, state, 3);
            }
            return state;
        }
    }

    public static interface BlockBreaker {
        default public boolean shouldBreak(BlockPos pos, BlockState state, float power, ServerLevel level) {
            return !ItemList.is(EXPLOSION_TRANSPARENT, state);
        }

        default public BlockState applyBreak(ExplosionCustom boom, BlockPos pos, BlockState state, float power, boolean destroy, ServerLevel level) {
            if (!destroy) {
                return state;
            }
            BlockState to = Blocks.f_50016_.m_49966_();
            if (power < 36.0f) {
                if (state.m_60767_() == Material.f_76274_) {
                    to = Blocks.f_50083_.m_49966_();
                }
                if (state.m_60767_() == Material.f_76302_) {
                    to = Blocks.f_50083_.m_49966_();
                }
            }
            level.m_7731_(pos, to, 3);
            return to;
        }

        default public BlockState onAbsorbed(ExplosionCustom boom, BlockPos pos, BlockState state, float power, boolean canEffect, ServerLevel level) {
            return state;
        }

        default public void destroyBlocks(BlastResult result, ExplosionCustom boom) {
            for (Object2FloatMap.Entry entry : result.destroyedBlocks.object2FloatEntrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                float power = entry.getFloatValue();
                BlockState state = boom.f_46012_.m_8055_(pos);
                BlockState broken = this.applyBreak(boom, pos, state, power, this.shouldBreak(pos, state, power, boom.f_46012_), boom.f_46012_);
                if (broken == state) continue;
                boom.m_46081_().add(pos);
            }
        }

        default public void damageBlocks(BlastResult result, ExplosionCustom boom) {
            for (Object2FloatMap.Entry entry : result.damagedBlocks.object2FloatEntrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                float power = entry.getFloatValue();
                BlockState state = boom.f_46012_.m_8055_(pos);
                BlockState broken = this.onAbsorbed(boom, pos, state, power, this.shouldBreak(pos, state, power, boom.f_46012_), boom.f_46012_);
                if (broken == state) continue;
                boom.m_46081_().add(pos);
            }
        }
    }

    public static class BlastResult {
        public final Object2FloatOpenHashMap<BlockPos> destroyedBlocks;
        public final Object2FloatOpenHashMap<BlockPos> damagedBlocks;
        public final Set<ChunkPos> affectedChunks;
        public final List<HitEntity> hit;
        public final boolean done;

        public BlastResult(Object2FloatOpenHashMap<BlockPos> results, Object2FloatOpenHashMap<BlockPos> remaining, List<HitEntity> hit, Set<ChunkPos> affectedChunks, boolean done) {
            this.destroyedBlocks = results;
            this.damagedBlocks = remaining;
            this.hit = hit;
            this.done = done;
            this.affectedChunks = affectedChunks;
        }
    }

    public static class HitEntity {
        final Entity entity;
        final float blastStrength;

        public HitEntity(Entity entity, float blastStrength) {
            this.entity = entity;
            this.blastStrength = blastStrength;
        }
    }
}

