/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import thut.api.boom.AbstractChecker;
import thut.api.boom.ExplosionCustom;
import thut.api.item.ItemList;
import thut.api.maths.Vector3;
import thut.api.maths.vecmath.Vec3f;
import thut.core.common.ThutCore;

public abstract class ShadowMaskChecker
extends AbstractChecker {
    final Vec3f unit = new Vec3f();
    Vec3f min = new Vec3f(-1.0f, -1.0f, -1.0f);
    Vec3f max = new Vec3f(1.0f, 1.0f, 1.0f);
    Vec3f min_next = new Vec3f(1.0f, 1.0f, 1.0f);
    Vec3f max_next = new Vec3f(-1.0f, -1.0f, -1.0f);
    int currentIndex = 0;
    int nextIndex = 0;
    int currentRadius = 0;
    double last_phi = 0.0;
    double last_rad = 0.25;
    int ind1;
    int ind2;
    int ind3;
    int ind4;
    float lastBoundCheck = 10.0f;
    Long2FloatOpenHashMap resistMap = new Long2FloatOpenHashMap();
    LongSet blockedSet = new LongOpenHashSet();
    ShadowMap shadow;
    ResistCache resists;
    LongSet checked = new LongOpenHashSet();
    LongSet seen = new LongOpenHashSet();
    Cubes cubes;
    Vector3 r = new Vector3();
    Vector3 rAbs = new Vector3();
    Vector3 rHat = new Vector3();
    Vector3 rTest = new Vector3();
    Vector3 rTestPrev = new Vector3();
    Vector3 rTestAbs = new Vector3();

    public ShadowMaskChecker(ExplosionCustom boom) {
        super(boom);
        this.cubes = new Cubes(boom);
        this.shadow = new ShadowSet(boom);
        this.resists = new ResistMap();
        this.resists = this.cubes;
        this.lastBoundCheck = boom.centre.intY() - boom.f_46012_.m_6924_(Heightmap.Types.MOTION_BLOCKING, boom.centre.intX(), boom.centre.intZ()) + 10;
        this.lastBoundCheck = Math.max(this.lastBoundCheck, 10.0f);
    }

    private boolean outOfBounds(Vec3f unit) {
        if (unit.x < this.min.x) {
            return true;
        }
        if (unit.y < this.min.y) {
            return true;
        }
        if (unit.z < this.min.z) {
            return true;
        }
        if (unit.x > this.max.x) {
            return true;
        }
        if (unit.y > this.max.y) {
            return true;
        }
        return unit.z > this.max.z;
    }

    private void validateMinMax(float r) {
        if (r - this.lastBoundCheck > 5.0f) {
            this.min.set(this.min_next);
            this.max.set(this.max_next);
            float s = 1.0f;
            this.min.scale(1.0f);
            this.max.scale(1.0f);
            this.min_next.set(1.0f, 1.0f, 1.0f);
            this.max_next.set(-1.0f, -1.0f, -1.0f);
            this.lastBoundCheck = r;
            ThutCore.LOGGER.debug("Strength: {}, Max radius: {}, Last Radius: {}", (Object)Float.valueOf(this.boom.strength), (Object)this.boom.f_46017_, (Object)((int)r));
            this.shadow.clean(this.boom);
        } else {
            this.min_next.x = Math.min(this.min_next.x, this.unit.x);
            this.min_next.y = Math.min(this.min_next.y, this.unit.y);
            this.min_next.z = Math.min(this.min_next.z, this.unit.z);
            this.max_next.x = Math.max(this.max_next.x, this.unit.x);
            this.max_next.y = Math.max(this.max_next.y, this.unit.y);
            this.max_next.z = Math.max(this.max_next.z, this.unit.z);
        }
    }

    protected boolean run(double radSq, int num, Set<ChunkPos> seen, Object2FloatOpenHashMap<BlockPos> destroyed, Object2FloatOpenHashMap<BlockPos> remaining, List<ExplosionCustom.HitEntity> entityAffected) {
        boolean doAirCheck;
        if (this.r.y + this.boom.centre.y > (double)this.boom.f_46012_.m_151558_()) {
            return false;
        }
        double rSq = this.r.magSq();
        if (rSq > radSq) {
            return false;
        }
        double rMag = Math.sqrt(rSq);
        this.rAbs.set(this.r).addTo(this.boom.centre);
        this.rHat.set(this.r).norm();
        BlockPos relPos = this.r.getPos();
        this.unit.set(this.rHat);
        if (this.outOfBounds(this.unit)) {
            return false;
        }
        double str = (double)this.boom.strength / rSq;
        if (str <= (double)this.boom.minBlastDamage) {
            return true;
        }
        if (this.shadow.hasHit(relPos)) {
            return false;
        }
        this.shadow.hit(relPos);
        ++this.ind4;
        if (this.shadow.blocked(relPos, this.rHat)) {
            ++this.ind1;
            return false;
        }
        ChunkPos cpos = new ChunkPos(this.rAbs.getPos());
        if (seen.add(cpos)) {
            this.boom.f_46012_.m_6325_(cpos.f_45578_, cpos.f_45579_);
        }
        boolean bl = doAirCheck = this.rHat.y < (double)this.max.y * 0.9 && this.rHat.y > (double)this.min.y * 0.9;
        if (doAirCheck && this.rAbs.isAir((BlockGetter)this.boom.f_46012_) && !this.r.isEmpty()) {
            float res;
            List hits;
            if (ExplosionCustom.AFFECTINAIR && (hits = this.boom.f_46012_.m_45933_(this.boom.exploder, this.rAbs.getAABB().m_82377_(0.5, 0.5, 0.5))) != null && !hits.isEmpty() && (double)(res = this.resists.getTotalValue(this.rHat, (float)(rMag = this.r.mag()), 0, this)) <= str) {
                for (Entity e : hits) {
                    entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
                }
            }
            this.validateMinMax((float)rMag);
            return false;
        }
        if (!this.boom.canBreak(this.rAbs, this.rAbs.getBlockState((BlockGetter)this.boom.f_46012_))) {
            this.shadow.block(relPos, this.rHat);
            ++this.ind2;
            return false;
        }
        float res = this.boom.resistProvider.getResistance(this.rAbs.getPos(), this.boom);
        this.resists.set(relPos, res);
        rMag = this.r.mag();
        res = this.resists.getTotalValue(this.rHat, (float)rMag, 0, this);
        if ((double)res > str) {
            this.shadow.block(relPos, this.rHat);
            remaining.put((Object)this.rAbs.getPos().m_7949_(), (float)str);
            return false;
        }
        this.validateMinMax((float)rMag);
        this.rAbs.set(this.r).addTo(this.boom.centre);
        BlockPos pos = this.rAbs.getPos().m_7949_();
        this.boom.m_46081_().add(pos);
        List hits = this.boom.f_46012_.m_45933_(this.boom.exploder, this.rAbs.getAABB().m_82377_(0.5, 0.5, 0.5));
        if (hits != null) {
            for (Entity e : hits) {
                entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
            }
        }
        destroyed.addTo((Object)pos, (float)str);
        return false;
    }

    protected abstract boolean apply(Object2FloatOpenHashMap<BlockPos> var1, Object2FloatOpenHashMap<BlockPos> var2, List<ExplosionCustom.HitEntity> var3, HashSet<ChunkPos> var4);

    @Override
    protected ExplosionCustom.BlastResult getBlocksToRemove() {
        this.beginLoop();
        Object2FloatOpenHashMap destroyed = new Object2FloatOpenHashMap();
        Object2FloatOpenHashMap remaining = new Object2FloatOpenHashMap();
        ArrayList entityAffected = Lists.newArrayList();
        HashSet<ChunkPos> seen = new HashSet<ChunkPos>();
        boolean done = this.apply((Object2FloatOpenHashMap<BlockPos>)destroyed, (Object2FloatOpenHashMap<BlockPos>)remaining, entityAffected, seen);
        this.endLoop();
        return new ExplosionCustom.BlastResult((Object2FloatOpenHashMap<BlockPos>)destroyed, (Object2FloatOpenHashMap<BlockPos>)remaining, entityAffected, seen, done);
    }

    @Override
    protected void printDebugInfo() {
        this.realTotalTime = System.nanoTime() - this.realTotalTime;
        ThutCore.LOGGER.info("Strength: {}, Max radius: {}, Last Radius: {}", (Object)Float.valueOf(this.boom.strength / this.boom.factor), (Object)this.boom.f_46017_, (Object)this.r.mag());
        ThutCore.LOGGER.info("time (tick/real): {}/{}ms, {} shadowed, {} denied, {} blocked, {} checked", (Object)((double)this.totalTime / 1000000.0), (Object)((double)this.realTotalTime / 1000000.0), (Object)this.ind1, (Object)this.ind2, (Object)this.ind3, (Object)this.ind4);
        ThutCore.LOGGER.info("bounds: {} {}", (Object)this.min, (Object)this.max);
    }

    public static class Cubes
    implements ResistCache {
        final Int2ObjectOpenHashMap<Cube> cubes;
        int minCube = Integer.MAX_VALUE;
        int minFound = -1;
        Vector3 tmp = new Vector3();

        public Cubes(ExplosionCustom boom) {
            this.cubes = new Int2ObjectOpenHashMap(boom.f_46017_, 0.25f);
        }

        Cube getCube(BlockPos r) {
            int z;
            int y;
            int x = Math.abs(r.m_123341_());
            int max = Math.max(x, Math.max(y = Math.abs(r.m_123342_()), z = Math.abs(r.m_123343_())));
            if (!this.cubes.containsKey(max)) {
                Cube c = new Cube();
                c.radius = max;
                this.cubes.put(max, (Object)c);
                return c;
            }
            this.minFound = this.minFound == -1 ? max : Math.min(max, this.minFound);
            this.minCube = Math.min(max, this.minCube);
            return (Cube)this.cubes.get(max);
        }

        BlockPos getPrevPos(Vector3 r, Vector3 rHat) {
            this.tmp.set(r).addTo(0.5, 0.5, 0.5).subtractFrom(rHat);
            return this.tmp.getPos().m_7949_();
        }

        Cube getPrev(Vector3 r, Vector3 rHat) {
            if (r.magSq() <= 1.0) {
                return null;
            }
            return this.getCube(this.getPrevPos(r, rHat));
        }

        @Override
        public float getTotalValue(Vector3 rHat, float r, int minCube, ShadowMaskChecker boom) {
            return ResistCache.super.getTotalValue(rHat, r, minCube, boom);
        }

        void removeLess() {
            while (this.minFound > this.minCube) {
                this.cubes.remove(this.minCube);
                ++this.minCube;
            }
            this.minFound = -1;
            this.minCube = Integer.MAX_VALUE;
        }

        @Override
        public final float get(BlockPos pos) {
            Cube c = this.getCube(pos);
            return c.get(pos);
        }

        @Override
        public final void set(BlockPos pos, float var) {
            this.getCube(pos).set(pos, var);
        }

        @Override
        public final boolean has(BlockPos pos) {
            return this.getCube(pos).has(pos);
        }

        @Override
        public void clean(ExplosionCustom boom) {
            this.removeLess();
        }
    }

    public static class ShadowSet
    implements ShadowMap {
        LongSet blockedSet = new LongOpenHashSet();
        final Cubes hitTracker;
        final float num;
        Vector3 tmp = new Vector3();

        public ShadowSet(ExplosionCustom boom) {
            float scaleFactor = 10.0f;
            int num = (int)Math.sqrt((double)(boom.strength * 10.0f) / 0.5);
            int max = boom.f_46017_ * 2 + 1;
            this.num = (float)Math.min(num, max) / 2.0f;
            this.hitTracker = new Cubes(boom);
        }

        @Override
        public final boolean blocked(BlockPos pos, Vector3 dir) {
            this.tmp.set(dir).scalarMultBy(this.num);
            long key = this.tmp.getPos().m_121878_();
            return this.blockedSet.contains(key);
        }

        @Override
        public final void block(BlockPos pos, Vector3 dir) {
            this.tmp.set(dir).scalarMultBy(this.num);
            long key = this.tmp.getPos().m_121878_();
            this.blockedSet.add(key);
        }

        @Override
        public final boolean hasHit(BlockPos pos) {
            return this.hitTracker.has(pos);
        }

        @Override
        public final void hit(BlockPos pos) {
            this.hitTracker.set(pos, 1.0f);
        }

        @Override
        public void clean(ExplosionCustom boom) {
            this.hitTracker.clean(boom);
        }
    }

    public static interface ShadowMap {
        public boolean blocked(BlockPos var1, Vector3 var2);

        public void block(BlockPos var1, Vector3 var2);

        public boolean hasHit(BlockPos var1);

        public void hit(BlockPos var1);

        default public void clean(ExplosionCustom boom) {
        }
    }

    public static class ResistMap
    implements ResistCache {
        Long2FloatOpenHashMap resists = new Long2FloatOpenHashMap();

        @Override
        public float get(BlockPos pos) {
            return this.resists.getOrDefault(pos.m_121878_(), 0.0f);
        }

        @Override
        public void set(BlockPos pos, float var) {
            this.resists.put(pos.m_121878_(), var);
        }

        @Override
        public boolean has(BlockPos pos) {
            return this.resists.containsKey(pos.m_121878_());
        }
    }

    public static interface ResistCache {
        public float get(BlockPos var1);

        public void set(BlockPos var1, float var2);

        public boolean has(BlockPos var1);

        default public void clean(ExplosionCustom boom) {
        }

        default public float getTotalValue(Vector3 rHat, float r, int minCube, ShadowMaskChecker boom) {
            float resist = 0.0f;
            for (float j = 0.0f; j <= r; j += 1.0f) {
                boom.rTest.set(boom.rHat).scalarMultBy(j);
                if (!boom.rTest.sameBlock(boom.rTestPrev)) {
                    float res;
                    boom.rTestAbs.set(boom.rTest).addTo(boom.boom.centre);
                    BlockPos testPos = boom.rTest.getPos();
                    if (this.has(testPos)) {
                        res = this.get(testPos);
                    } else {
                        ChunkPos cpos = new ChunkPos(boom.rTestAbs.getPos());
                        boom.boom.f_46012_.m_6325_(cpos.f_45578_, cpos.f_45579_);
                        res = boom.boom.resistProvider.getResistance(boom.rTestAbs.getPos(), boom.boom);
                        this.set(testPos, res);
                    }
                    resist += res;
                    float str = (float)((double)boom.boom.strength / boom.rTest.magSq());
                    if (resist > str) {
                        boom.shadow.block(boom.r.getPos(), boom.rHat);
                        ++boom.ind3;
                        return boom.boom.strength;
                    }
                }
                boom.rTestPrev.set(boom.rTest);
            }
            return 0.0f;
        }
    }

    public static interface ResistProvider {
        default public float getResistance(BlockPos pos, ExplosionCustom boom) {
            BlockState state = boom.f_46012_.m_8055_(pos);
            if (ItemList.is(ExplosionCustom.EXPLOSION_TRANSPARENT, state)) {
                return 0.0f;
            }
            float resist = state.getExplosionResistance((BlockGetter)boom.f_46012_, pos, (Explosion)boom);
            if (ItemList.is(ExplosionCustom.EXPLOSION_2X_WEAK, state)) {
                resist /= 2.0f;
            }
            if (ItemList.is(ExplosionCustom.EXPLOSION_10X_WEAK, state)) {
                resist /= 10.0f;
            }
            if (resist > 1.0f) {
                resist *= resist;
            }
            return resist;
        }
    }

    public static class Cube
    implements ResistCache {
        final Long2FloatOpenHashMap resistMap = new Long2FloatOpenHashMap(1024, 0.75f);
        int radius = 1;
        boolean had = false;

        public boolean isOn(BlockPos r) {
            boolean zFace;
            boolean yFace;
            boolean xFace;
            int z;
            int y;
            int x = Math.abs(r.m_123341_());
            int max = Math.max(x, Math.max(y = Math.abs(r.m_123342_()), z = Math.abs(r.m_123343_())));
            if (max != this.radius) {
                return false;
            }
            boolean bl = xFace = x == this.radius && y <= this.radius && z <= this.radius;
            if (xFace) {
                return true;
            }
            boolean bl2 = yFace = y == this.radius && x <= this.radius && z <= this.radius;
            if (yFace) {
                return true;
            }
            boolean bl3 = zFace = z == this.radius && y <= this.radius && x <= this.radius;
            return zFace;
        }

        @Override
        public float get(BlockPos r) {
            if (!this.isOn(r)) {
                ThutCore.LOGGER.error("wrong cube? " + r + " " + this.radius);
                return 0.0f;
            }
            this.had = false;
            float res = this.resistMap.getOrDefault(r.m_121878_(), -1.0f);
            boolean bl = this.had = res != -1.0f;
            if (!this.had) {
                res = 0.0f;
            }
            return res;
        }

        @Override
        public void set(BlockPos r, float v) {
            if (!this.isOn(r)) {
                ThutCore.LOGGER.error("wrong cube? " + r + " " + this.radius);
                return;
            }
            this.resistMap.put(r.m_121878_(), v);
        }

        @Override
        public boolean has(BlockPos pos) {
            return this.resistMap.containsKey(pos.m_121878_());
        }
    }
}

