/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import thut.api.ThutCaps;
import thut.api.entity.IBreedingMob;
import thut.core.common.ThutCore;
import thut.lib.RegHelper;

public class BreedableCaps {
    public static final ResourceLocation WRAP = new ResourceLocation("thutcore:breedable_wrap");

    private static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        for (ICapabilityProvider p : event.getCapabilities().values()) {
            if (!p.getCapability(ThutCaps.BREEDS).isPresent()) continue;
            return;
        }
        Object object = event.getObject();
        if (object instanceof AgeableMob) {
            AgeableMob mob = (AgeableMob)object;
            event.addCapability(WRAP, (ICapabilityProvider)new AgeableWrapper(mob));
        }
    }

    public static IBreedingMob getBreedable(ICapabilityProvider in) {
        if (in == null) {
            return null;
        }
        return (IBreedingMob)in.getCapability(ThutCaps.BREEDS).orElse(null);
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, EventPriority.LOWEST, BreedableCaps::attachMobs);
    }

    public static class AgeableWrapper
    extends Impl {
        final AgeableMob wrapped;

        public AgeableWrapper(AgeableMob wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Object getChild(IBreedingMob male) {
            return this.wrapped.m_142606_((ServerLevel)this.wrapped.m_9236_(), male.getEntity());
        }

        @Override
        public boolean canMate(AgeableMob other) {
            try {
                AgeableMob ageableMob = this.wrapped;
                if (ageableMob instanceof Animal) {
                    Animal a = (Animal)ageableMob;
                    if (other instanceof Animal) {
                        Animal b = (Animal)other;
                        return a.m_7848_(b);
                    }
                }
            }
            catch (Exception e) {
                if (!ThutCore.conf.supress_warns) {
                    ThutCore.LOGGER.warn("Warning, Mob {} has messed up canMateWith check!", (Object)RegHelper.getKey(this.wrapped.m_6095_()));
                }
                return false;
            }
            return other.getClass() == this.wrapped.getClass();
        }

        @Override
        public boolean canBreed() {
            AgeableMob ageableMob = this.wrapped;
            if (ageableMob instanceof Animal) {
                Animal animal = (Animal)ageableMob;
                return animal.m_35506_();
            }
            return super.canBreed();
        }

        @Override
        public boolean isBreeding() {
            AgeableMob ageableMob = this.wrapped;
            if (ageableMob instanceof Animal) {
                Animal animal = (Animal)ageableMob;
                return animal.m_27593_();
            }
            return super.isBreeding();
        }

        @Override
        public void setReadyToMate(@Nullable Player cause) {
            AgeableMob ageableMob = this.wrapped;
            if (ageableMob instanceof Animal) {
                Animal animal = (Animal)ageableMob;
                animal.m_27595_(cause);
            }
        }

        @Override
        public void resetLoveStatus() {
            AgeableMob ageableMob = this.wrapped;
            if (ageableMob instanceof Animal) {
                Animal animal = (Animal)ageableMob;
                animal.m_27594_();
            }
        }

        @Override
        public ServerPlayer getCause() {
            AgeableMob ageableMob = this.wrapped;
            if (ageableMob instanceof Animal) {
                Animal animal = (Animal)ageableMob;
                return animal.m_27592_();
            }
            return super.getCause();
        }
    }

    public static class Impl
    implements IBreedingMob,
    ICapabilityProvider {
        private final LazyOptional<IBreedingMob> holder = LazyOptional.of(() -> this);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.BREEDS.orEmpty(cap, this.holder);
        }

        @Override
        public AgeableMob getEntity() {
            return null;
        }
    }
}

