/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import thut.api.ThutCaps;
import thut.api.entity.ICopyMob;
import thut.api.entity.animation.CapabilityAnimation;
import thut.core.common.network.CapabilitySync;
import thut.lib.RegHelper;

public class CopyCaps {
    public static final ResourceLocation LOC = new ResourceLocation("thutcore:copymob");
    public static final ResourceLocation ANIM = new ResourceLocation("thutcore:animations");
    private static final Set<ResourceLocation> ATTACH_TO = Sets.newHashSet();

    public static ICopyMob get(ICapabilityProvider in) {
        return (ICopyMob)in.getCapability(ThutCaps.COPYMOB).orElse(null);
    }

    private static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        if (!ATTACH_TO.contains(RegHelper.getKey(((Entity)event.getObject()).m_6095_()))) {
            return;
        }
        if (!event.getCapabilities().containsKey(LOC)) {
            event.addCapability(LOC, (ICapabilityProvider)new Impl());
        }
        if (!event.getCapabilities().containsKey(ANIM)) {
            event.addCapability(ANIM, (ICapabilityProvider)new CapabilityAnimation.DefaultImpl());
        }
    }

    private static void onEntitySizeSet(EntityEvent.Size event) {
        ICopyMob copyMob = CopyCaps.get((ICapabilityProvider)event.getEntity());
        if (copyMob == null || copyMob.getCopiedMob() == null) {
            return;
        }
        LivingEntity copied = copyMob.getCopiedMob();
        Pose pose = event.getEntity().m_20089_();
        EntityDimensions dims = copied.m_6972_(pose);
        float height = dims.f_20378_;
        float width = dims.f_20377_;
        float eye = copied.m_6380_(pose, dims);
        event.setNewEyeHeight(eye);
        event.setNewSize(EntityDimensions.m_20398_((float)width, (float)height));
    }

    private static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        ICopyMob copyMob = CopyCaps.get((ICapabilityProvider)event.getEntity());
        if (copyMob == null) {
            return;
        }
        copyMob.onBaseTick(event.getEntity().f_19853_, event.getEntity());
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, EventPriority.LOWEST, CopyCaps::attachMobs);
        MinecraftForge.EVENT_BUS.addListener(CopyCaps::onEntitySizeSet);
        MinecraftForge.EVENT_BUS.addListener(CopyCaps::onLivingUpdate);
        CapabilitySync.TO_SYNC.add(LOC.toString());
        CapabilitySync.TO_SYNC.add(ANIM.toString());
        CopyCaps.register(EntityType.f_20532_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(EntityType<?> type) {
        Set<ResourceLocation> set = ATTACH_TO;
        synchronized (set) {
            ATTACH_TO.add(RegHelper.getKey(type));
        }
    }

    public static class Impl
    implements ICopyMob,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<ICopyMob> holder = LazyOptional.of(() -> this);
        public ResourceLocation copiedID = null;
        public LivingEntity copiedMob = null;
        public CompoundTag copiedNBT = new CompoundTag();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.COPYMOB.orEmpty(cap, this.holder);
        }

        @Override
        public ResourceLocation getCopiedID() {
            return this.copiedID;
        }

        @Override
        public LivingEntity getCopiedMob() {
            return this.copiedMob;
        }

        @Override
        public CompoundTag getCopiedNBT() {
            return this.copiedNBT;
        }

        @Override
        public void setCopiedID(ResourceLocation id) {
            this.copiedID = id;
        }

        @Override
        public void setCopiedMob(LivingEntity mob) {
            this.copiedMob = mob;
        }

        @Override
        public void setCopiedNBT(CompoundTag tag) {
            this.copiedNBT = tag;
        }
    }
}

