/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import thut.api.entity.animation.Animation;

public interface IAnimated {
    public List<String> getChoices();

    public static interface IAnimationHolder {
        public void clean();

        public String getPendingAnimations();

        public List<Animation> getPlaying();

        public void setPendingAnimations(List<Animation> var1, String var2);

        public void setStep(Animation var1, float var2);

        public String getAnimation(Entity var1);

        public void preRun();

        public void postRun();

        public boolean isFixed();

        public void setFixed(boolean var1);

        public void overridePlaying(String var1);

        @Nonnull
        public HeadInfo getHeadInfo();

        public void initAnimations(Map<String, List<Animation>> var1, String var2);
    }

    public static class HeadInfo {
        public static final HeadInfo DUMMY = new HeadInfo();
        public float headYaw;
        public float headPitch;
        public int currentTick = 0;
        public int lastTick = 0;
        public float yawCapMax = 180.0f;
        public float yawCapMin = -180.0f;
        public float pitchCapMax = 40.0f;
        public float pitchCapMin = -40.0f;
        public int yawAxis = 1;
        public int pitchAxis = 0;
        public int yawDirection = 1;
        public int pitchDirection = 1;
        public boolean fixed = false;

        public void copyFrom(HeadInfo other) {
            this.yawAxis = other.yawAxis;
            this.yawCapMin = other.yawCapMin;
            this.yawCapMax = other.yawCapMax;
            this.yawDirection = other.yawDirection;
            this.pitchAxis = other.pitchAxis;
            this.pitchCapMin = other.pitchCapMin;
            this.pitchCapMax = other.pitchCapMax;
            this.pitchDirection = other.pitchDirection;
        }
    }
}

