/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import thut.api.entity.event.CopySetEvent;
import thut.api.entity.event.CopyUpdateEvent;
import thut.lib.RegHelper;

public interface ICopyMob
extends INBTSerializable<CompoundTag> {
    public ResourceLocation getCopiedID();

    public LivingEntity getCopiedMob();

    public CompoundTag getCopiedNBT();

    public void setCopiedID(ResourceLocation var1);

    public void setCopiedMob(LivingEntity var1);

    public void setCopiedNBT(CompoundTag var1);

    default public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("id")) {
            this.setCopiedID(new ResourceLocation(nbt.m_128461_("id")));
        } else {
            this.setCopiedID(null);
        }
        this.setCopiedNBT(nbt.m_128469_("tag"));
    }

    default public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.getCopiedID() != null) {
            nbt.m_128359_("id", this.getCopiedID().toString());
        }
        if (!this.getCopiedNBT().m_128456_()) {
            nbt.m_128365_("tag", (Tag)this.getCopiedNBT());
        }
        return nbt;
    }

    default public void baseInit(@Nonnull Level level, @Nullable LivingEntity holder) {
        if (this.getCopiedID() == null) {
            if (this.getCopiedMob() != null) {
                LivingEntity mob;
                if (holder != null && MinecraftForge.EVENT_BUS.post((Event)new CopySetEvent(holder, mob = this.getCopiedMob(), null))) {
                    this.setCopiedID(RegHelper.getKey(this.getCopiedMob().m_6095_()));
                    this.setCopiedMob(mob);
                    this.setCopiedNBT(mob.serializeNBT());
                    return;
                }
                this.setCopiedMob(null);
                this.setCopiedNBT(new CompoundTag());
            }
            return;
        }
        if (this.getCopiedMob() == null || !this.getCopiedID().equals((Object)RegHelper.getKey(this.getCopiedMob().m_6095_()))) {
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.getCopiedID());
            Entity entity = type.m_20615_(level);
            if (entity instanceof LivingEntity) {
                LivingEntity mob = (LivingEntity)entity;
                if (MinecraftForge.EVENT_BUS.post((Event)new CopySetEvent(holder, null, mob))) {
                    this.setCopiedID(null);
                    this.setCopiedNBT(new CompoundTag());
                    return;
                }
                this.setCopiedMob(mob);
                try {
                    mob.deserializeNBT(this.getCopiedNBT());
                    this.setCopiedNBT(mob.serializeNBT());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.setCopiedID(null);
                this.setCopiedNBT(new CompoundTag());
                return;
            }
        }
    }

    default public void onBaseTick(@Nonnull Level level, @Nullable LivingEntity holder) {
        this.baseInit(level, holder);
        LivingEntity living = this.getCopiedMob();
        if (living != null && holder != null) {
            living.m_20234_(-(holder.m_19879_() + 100));
            living.onAddedToWorld();
            living.m_6075_();
            living.onRemovedFromWorld();
            float eye = living.m_6380_(holder.m_20089_(), holder.m_6972_(holder.m_20089_()));
            if (eye != holder.m_6380_(holder.m_20089_(), holder.m_6972_(holder.m_20089_()))) {
                holder.m_6210_();
            }
            living.m_21008_(InteractionHand.MAIN_HAND, holder.m_21120_(InteractionHand.MAIN_HAND));
            living.m_21008_(InteractionHand.OFF_HAND, holder.m_21120_(InteractionHand.OFF_HAND));
            living.f_19794_ = true;
            ICopyMob.copyEntityTransforms(living, holder);
            ICopyMob.copyPositions((Entity)living, (Entity)holder);
            living.f_19853_ = holder.f_19853_;
            if (!MinecraftForge.EVENT_BUS.post((Event)new CopyUpdateEvent(living, holder))) {
                living.m_21153_(holder.m_21223_());
                living.m_20301_(holder.m_20146_());
            }
        }
    }

    public static void copyPositions(Entity to, Entity from) {
        to.f_19790_ = from.f_19790_;
        to.f_19791_ = from.f_19791_;
        to.f_19792_ = from.f_19792_;
        to.f_19854_ = from.f_19854_;
        to.f_19855_ = from.f_19855_;
        to.f_19856_ = from.f_19856_;
        to.m_6034_(from.m_20185_(), from.m_20186_(), from.m_20189_());
        to.m_20256_(from.m_20184_());
    }

    public static void copyRotations(Entity to, Entity from) {
        to.f_19858_ = from.f_19858_;
        to.f_19797_ = from.f_19797_;
        to.f_19857_ = from.f_19857_;
        to.m_5616_(from.m_6080_());
        to.f_19860_ = from.f_19860_;
        to.f_19859_ = from.f_19859_;
    }

    public static void copyEntityTransforms(LivingEntity to, LivingEntity from) {
        ICopyMob.copyRotations((Entity)to, (Entity)from);
        to.f_20886_ = from.f_20886_;
        to.f_20884_ = from.f_20884_;
        to.f_20883_ = from.f_20883_;
        to.f_20923_ = from.f_20923_;
        to.f_20925_ = from.f_20925_;
        to.f_20924_ = from.f_20924_;
        to.m_6853_(from.m_20096_());
        to.f_19798_ = from.f_19798_;
        to.f_19799_ = from.f_19799_;
        to.f_19801_.clear();
        to.f_19801_.addAll(from.f_19801_);
    }
}

