/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import thut.core.client.render.animation.AnimationXML;

public interface IMobTexturable {
    public Entity getEntity();

    default public String getModId() {
        return "minecraft";
    }

    default public String getForm() {
        return "";
    }

    default public int getRandomSeed() {
        return 0;
    }

    default public ResourceLocation getTexture(@Nullable String part) {
        if (part == null) {
            return new ResourceLocation("");
        }
        return new ResourceLocation(this.getModId(), part);
    }

    default public List<String> getTextureStates() {
        return Collections.emptyList();
    }

    default public ResourceLocation preApply(ResourceLocation in) {
        return in;
    }

    default public void applyTexturePhase(AnimationXML.Phase phase) {
    }

    public static class Defaults
    implements IMobTexturable {
        @Override
        public Entity getEntity() {
            return null;
        }
    }
}

