/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import thut.api.maths.vecmath.Mat3f;
import thut.api.maths.vecmath.Vec3f;

public interface IMultiplePassengerEntity {
    public static final EntityDataSerializer<Seat> SEATSERIALIZER = new EntityDataSerializer<Seat>(){

        public Seat copy(Seat value) {
            return new Seat((Vec3f)value.seat.clone(), value.getEntityId());
        }

        public EntityDataAccessor<Seat> m_135021_(int id) {
            return new EntityDataAccessor(id, (EntityDataSerializer)this);
        }

        public Seat read(FriendlyByteBuf buf) {
            return new Seat(buf);
        }

        public void write(FriendlyByteBuf buf, Seat value) {
            value.writeToBuf(buf);
        }
    };

    public Entity getPassenger(Vec3f var1);

    public float getPitch();

    public float getPrevPitch();

    public float getPrevYaw();

    public Vec3f getSeat(Entity var1);

    public List<Vec3f> getSeats();

    public float getYaw();

    public void updateSeat(int var1, UUID var2);

    public static class Seat {
        public static final UUID BLANK = new UUID(0L, 0L);
        public Vec3f seat;
        private UUID entityId;

        public static Seat readFromNBT(CompoundTag tag) {
            byte[] arr = tag.m_128463_("v");
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])arr));
            return new Seat(buf);
        }

        public Seat(FriendlyByteBuf buf) {
            this.seat = new Vec3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
            this.setEntityId(new UUID(buf.readLong(), buf.readLong()));
        }

        public Seat(Vec3f vector3f, UUID readInt) {
            this.seat = vector3f;
            this.setEntityId(readInt != null ? readInt : BLANK);
        }

        public Object clone() {
            return new Seat((Vec3f)this.seat.clone(), this.getEntityId());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Seat)) {
                return false;
            }
            Seat other = (Seat)obj;
            return this.getEntityId().equals(other.getEntityId()) && this.seat.epsilonEquals(other.seat, 0.1f);
        }

        public UUID getEntityId() {
            return this.entityId;
        }

        public void setEntityId(UUID entityId) {
            this.entityId = entityId;
        }

        public String toString() {
            return this.seat + " " + this.getEntityId();
        }

        public void writeToBuf(FriendlyByteBuf buf) {
            buf.writeFloat(this.seat.x);
            buf.writeFloat(this.seat.y);
            buf.writeFloat(this.seat.z);
            buf.writeLong(this.getEntityId().getMostSignificantBits());
            buf.writeLong(this.getEntityId().getLeastSignificantBits());
        }

        public void writeToNBT(CompoundTag tag) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer((int)8));
            this.writeToBuf(buffer);
            tag.m_128382_("v", buffer.array());
        }
    }

    public static class MultiplePassengerManager {
        public static void managePassenger(Entity passenger, IMultiplePassengerEntity multipassenger) {
            Entity entity = (Entity)multipassenger;
            if (!entity.m_20363_(passenger)) {
                return;
            }
            Vec3f v = multipassenger.getSeat(passenger);
            float yaw = -multipassenger.getYaw() * ((float)Math.PI / 180);
            float pitch = -multipassenger.getPitch() * ((float)Math.PI / 180);
            float sinYaw = Mth.m_14031_((float)yaw);
            float cosYaw = Mth.m_14089_((float)yaw);
            float sinPitch = Mth.m_14031_((float)pitch);
            float cosPitch = Mth.m_14089_((float)pitch);
            Mat3f matrixYaw = new Mat3f(cosYaw, 0.0f, sinYaw, 0.0f, 1.0f, 0.0f, -sinYaw, 0.0f, cosYaw);
            Mat3f matrixPitch = new Mat3f(cosPitch, -sinPitch, 0.0f, sinPitch, cosPitch, 0.0f, 0.0f, 0.0f, 1.0f);
            Mat3f transform = new Mat3f();
            transform.mul(matrixYaw, matrixPitch);
            if (v == null) {
                v = new Vec3f();
            } else {
                v = (Vec3f)v.clone();
                transform.transform(v);
            }
            passenger.m_6034_(entity.m_20185_() + (double)v.x, entity.m_20186_() + passenger.m_6049_() + (double)v.y, entity.m_20189_() + (double)v.z);
        }
    }
}

