/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import thut.api.ThutCaps;
import thut.api.entity.IShearable;

public class ShearableCaps {
    public static final ResourceLocation LOC = new ResourceLocation("thutcore:shearable");

    public static IShearable get(ICapabilityProvider in) {
        return (IShearable)in.getCapability(ThutCaps.SHEARABLE).orElse(null);
    }

    private static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        if (event.getCapabilities().containsKey(LOC)) {
            return;
        }
        Object object = event.getObject();
        if (object instanceof Sheep) {
            Sheep sheep = (Sheep)object;
            event.addCapability(LOC, (ICapabilityProvider)new SheepImpl(sheep));
        }
    }

    public static void setup() {
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, ShearableCaps::attachMobs);
    }

    public static class SheepImpl
    extends Impl {
        final Sheep sheep;

        public SheepImpl(Sheep sheep) {
            this.sheep = sheep;
        }

        @Override
        public boolean isSheared() {
            return this.sheep.m_29875_();
        }

        @Override
        public void shear() {
            this.sheep.m_29878_(true);
        }
    }

    public static class Impl
    implements IShearable,
    ICapabilityProvider {
        private final LazyOptional<IShearable> holder = LazyOptional.of(() -> this);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.SHEARABLE.orEmpty(cap, this.holder);
        }

        @Override
        public boolean isSheared() {
            return false;
        }

        @Override
        public void shear() {
        }
    }

    public static class Wrapper
    extends Impl {
        final IShearable wrapped;

        public Wrapper(IShearable wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isSheared() {
            return this.wrapped.isSheared();
        }

        @Override
        public void shear() {
            this.wrapped.shear();
        }

        @Override
        public void shear(ItemStack shears) {
            this.wrapped.shear(shears);
        }
    }
}

