/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.entity.TeleLoadEvent;
import thut.api.maths.Vector3;
import thut.core.common.ThutCore;
import thut.lib.TComponent;

public class ThutTeleporter {
    public static void transferTo(Entity entity, TeleDest dest) {
        ThutTeleporter.transferTo(entity, dest, false);
    }

    public static void transferTo(Entity entity, TeleDest dest, boolean sound) {
        if (entity.m_9236_() instanceof ServerLevel) {
            new InvulnTicker(entity);
            if (dest.loc.m_122640_() == entity.f_19853_.m_46472_()) {
                ThutTeleporter.moveMob(entity, dest);
                return;
            }
            ServerLevel destWorld = entity.m_20194_().m_129880_(dest.loc.m_122640_());
            if (destWorld != null) {
                new TransferTicker(destWorld, entity, dest, sound);
            }
        }
    }

    private static void transferMob(ServerLevel destWorld, TeleDest dest, Entity entity) {
        ServerPlayer player = null;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            player.f_8927_ = true;
        }
        ServerLevel serverworld = (ServerLevel)entity.m_9236_();
        List passengers = entity.m_20197_();
        entity.m_20153_();
        for (int i = 0; i < passengers.size(); ++i) {
            Entity e = (Entity)passengers.get(i);
            e.getPersistentData().m_128379_("thutcore:dimtp", true);
            ThutTeleporter.transferTo(e, dest);
            e.getPersistentData().m_128473_("thutcore:dimtp");
            new RemountTicker(entity.m_20148_(), e.m_20148_(), i, destWorld);
        }
        ThutTeleporter.removeMob(serverworld, entity, true);
        entity.revive();
        entity.m_7678_(dest.subLoc.x, dest.subLoc.y, dest.subLoc.z, entity.f_19857_, entity.f_19858_);
        entity.f_19853_ = destWorld;
        ThutTeleporter.addMob(destWorld, entity);
        if (player != null) {
            player.f_8927_ = false;
            player.f_8906_.m_9953_();
            player.f_8906_.m_9774_(dest.subLoc.x, dest.subLoc.y, dest.subLoc.z, entity.f_19857_, entity.f_19858_);
        }
    }

    private static void addMob(ServerLevel world, Entity entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, (Level)world))) {
            return;
        }
        ChunkAccess ichunk = world.m_6522_(Mth.m_14107_((double)(entity.m_20185_() / 16.0)), Mth.m_14107_((double)(entity.m_20189_() / 16.0)), ChunkStatus.f_62326_, true);
        if (ichunk instanceof LevelChunk) {
            ichunk.m_6286_(entity);
        }
        world.m_143334_(entity);
    }

    private static void removeMob(ServerLevel world, Entity entity, boolean keepData) {
        entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
    }

    private static void moveMob(Entity entity, TeleDest dest) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double targetX = dest.getLoc().x;
            double targetY = dest.getLoc().y;
            double targetZ = dest.getLoc().z;
            TeleEvent event = TeleEvent.onUseTeleport(living, targetX, targetY, targetZ);
            if (event.isCanceled()) {
                return;
            }
            targetX = event.getTargetX();
            targetY = event.getTargetY();
            targetZ = event.getTargetZ();
            dest = new TeleDest().setLoc(GlobalPos.m_122643_((ResourceKey)dest.getPos().m_122640_(), (BlockPos)new BlockPos(targetX, targetY, targetZ)), new Vector3().set(targetX, targetY, targetZ));
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.f_8927_ = true;
            player.f_8906_.m_9774_(dest.subLoc.x, dest.subLoc.y, dest.subLoc.z, entity.f_19857_, entity.f_19858_);
            player.f_8906_.m_9953_();
            player.f_8927_ = false;
        } else {
            entity.m_6021_(dest.subLoc.x, dest.subLoc.y, dest.subLoc.z);
        }
    }

    public static class TeleDest {
        public GlobalPos loc;
        private Vector3 subLoc;
        private String name;
        public int index;
        public int version = 0;

        public static TeleDest readFromNBT(CompoundTag nbt) {
            Vector3 loc = Vector3.readFromNBT(nbt, "v");
            String name = nbt.m_128461_("name");
            int index = nbt.m_128451_("i");
            int version = nbt.m_128451_("_v_");
            GlobalPos pos = null;
            try {
                pos = (GlobalPos)((Pair)GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("pos")).result().get()).getFirst();
            }
            catch (Exception e) {
                ThutCore.LOGGER.error("Error loading value", (Throwable)e);
                return null;
            }
            TeleDest dest = new TeleDest().setLoc(pos, loc).setName(name).setIndex(index).setVersion(version);
            TeleLoadEvent event = new TeleLoadEvent(dest);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return null;
            }
            return event.getOverride();
        }

        public TeleDest setLoc(GlobalPos loc, Vector3 subLoc) {
            this.loc = loc;
            this.subLoc = subLoc;
            this.name = "";
            return this;
        }

        public TeleDest setPos(GlobalPos pos) {
            if (pos != null) {
                this.loc = pos;
                this.subLoc = new Vector3().set((double)this.loc.m_122646_().m_123341_() + 0.5, this.loc.m_122646_().m_123342_(), (double)this.loc.m_122646_().m_123343_() + 0.5);
                this.name = "";
            }
            return this;
        }

        public TeleDest setVersion(int version) {
            this.version = version;
            return this;
        }

        public GlobalPos getPos() {
            return this.loc;
        }

        public Vector3 getLoc() {
            return this.subLoc;
        }

        public String getName() {
            return this.name;
        }

        public TeleDest setIndex(int index) {
            this.index = index;
            return this;
        }

        public TeleDest setName(String name) {
            this.name = name;
            return this;
        }

        public void writeToNBT(CompoundTag nbt) {
            if (this.subLoc == null) {
                this.subLoc = new Vector3().set(this.loc.m_122646_()).add(0.5, 0.0, 0.5);
            }
            this.subLoc.writeToNBT(nbt, "v");
            nbt.m_128365_("pos", (Tag)GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.loc).get().left().get());
            nbt.m_128359_("name", this.name);
            nbt.m_128405_("i", this.index);
            nbt.m_128405_("_v_", this.version);
        }

        public void shift(double dx, int dy, double dz) {
            this.subLoc.x += dx;
            this.subLoc.y += (double)dy;
            this.subLoc.z += dz;
        }

        public Component getInfoName() {
            return TComponent.translatable("teledest.location", this.loc.m_122646_().m_123341_(), this.loc.m_122646_().m_123342_(), this.loc.m_122646_().m_123343_(), this.loc.m_122640_().m_135782_());
        }

        public boolean withinDist(TeleDest other, double dist) {
            if (other.loc.m_122640_() == this.loc.m_122640_()) {
                return other.loc.m_122646_().m_123314_((Vec3i)this.loc.m_122646_(), dist);
            }
            return false;
        }
    }

    private static class InvulnTicker {
        private final ServerLevel overworld;
        private final Entity entity;
        private final long start;

        public InvulnTicker(Entity entity) {
            this.entity = entity;
            this.overworld = entity.m_20194_().m_129880_(Level.f_46428_);
            this.start = this.overworld.m_46467_();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void damage(LivingHurtEvent event) {
            if (!event.getEntity().m_20148_().equals(this.entity.m_20148_())) {
                return;
            }
            long time = this.overworld.m_46467_();
            if (time - this.start > 20L) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            event.setCanceled(true);
        }
    }

    private static class TransferTicker {
        private final Entity entity;
        private final ServerLevel destWorld;
        private final TeleDest dest;
        private final boolean sound;

        public TransferTicker(ServerLevel destWorld, Entity entity, TeleDest dest, boolean sound) {
            this.entity = entity;
            this.dest = dest;
            this.sound = sound;
            this.destWorld = destWorld;
            boolean inTick = destWorld.m_8874_();
            if (inTick) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            } else if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8927_ = true;
                player.m_8999_(destWorld, dest.subLoc.x, dest.subLoc.y, dest.subLoc.z, entity.f_19857_, entity.f_19858_);
                if (sound) {
                    destWorld.m_7785_(dest.subLoc.x, dest.subLoc.y, dest.subLoc.z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
                player.f_8927_ = false;
            } else {
                ThutTeleporter.transferMob(this.destWorld, this.dest, this.entity);
                if (this.sound) {
                    this.destWorld.m_7785_(this.dest.subLoc.x, this.dest.subLoc.y, this.dest.subLoc.z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    this.entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
        }

        @SubscribeEvent
        public void tickEvent(TickEvent.LevelTickEvent event) {
            if (event.level == this.entity.m_9236_() && event.phase == TickEvent.Phase.END) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                Entity entity = this.entity;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.f_8927_ = true;
                    player.m_8999_(this.destWorld, this.dest.subLoc.x, this.dest.subLoc.y, this.dest.subLoc.z, this.entity.f_19857_, this.entity.f_19858_);
                    if (this.sound) {
                        this.destWorld.m_7785_(this.dest.subLoc.x, this.dest.subLoc.y, this.dest.subLoc.z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                        player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    }
                    player.f_8927_ = false;
                } else {
                    ThutTeleporter.transferMob(this.destWorld, this.dest, this.entity);
                    if (this.sound) {
                        this.destWorld.m_7785_(this.dest.subLoc.x, this.dest.subLoc.y, this.dest.subLoc.z, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                        this.entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private static class RemountTicker {
        private final UUID mount;
        private final UUID rider;
        final int index;
        private final ServerLevel world;
        int n = 0;

        public RemountTicker(UUID mount, UUID rider, int index, ServerLevel world) {
            this.mount = mount;
            this.rider = rider;
            this.world = world;
            this.index = index;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void TickEvent(TickEvent.LevelTickEvent event) {
            if (event.level != this.world) {
                return;
            }
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (this.n++ > 20) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            Entity mount = this.world.m_8791_(this.mount);
            Entity rider = this.world.m_8791_(this.rider);
            if (mount != null && rider != null) {
                --this.n;
                int num = mount.m_20197_().size();
                if (num == this.index) {
                    rider.m_7998_(mount, true);
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                }
            }
        }
    }

    @Cancelable
    public static class TeleEvent
    extends EntityTeleportEvent {
        public TeleEvent(Entity entity, double targetX, double targetY, double targetZ) {
            super(entity, targetX, targetY, targetZ);
        }

        public static TeleEvent onUseTeleport(LivingEntity entity, double targetX, double targetY, double targetZ) {
            TeleEvent event = new TeleEvent((Entity)entity, targetX, targetY, targetZ);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event;
        }
    }
}

