/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.ai;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import thut.api.entity.ai.VectorPosWrapper;
import thut.api.maths.Vector3;

public class BrainUtil {
    public static boolean targetIsValid(Brain<?> brain, MemoryModuleType<? extends LivingEntity> memory, Predicate<LivingEntity> validator) {
        return brain.m_21952_(memory).filter(validator).filter(LivingEntity::m_6084_).filter(mob -> BehaviorUtils.m_22636_((Brain)brain, (LivingEntity)mob)).isPresent();
    }

    public static boolean canSee(LivingEntity mobIn, LivingEntity target) {
        boolean canSee;
        boolean brainMemory = mobIn.m_6274_().m_21874_(MemoryModuleType.f_148205_);
        boolean bl = canSee = brainMemory && BehaviorUtils.m_22636_((Brain)mobIn.m_6274_(), (LivingEntity)target);
        if (!brainMemory) {
            canSee = mobIn.m_142582_((Entity)target);
        }
        return canSee;
    }

    public static void lookAt(LivingEntity entityIn, double x, double y, double z) {
        BrainUtil.lookAt(entityIn, new Vector3().set(x, y, z));
    }

    public static void lookAt(LivingEntity entityIn, Vector3 vec) {
        entityIn.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new VectorPosWrapper(vec));
    }

    public static void removeSensors(Brain<?> brain, List<SensorType<?>> SENSOR_TYPES) {
        for (SensorType<?> type : SENSOR_TYPES) {
            brain.f_21844_.remove(type);
        }
    }

    public static void addToBrain(Brain<?> brain, List<MemoryModuleType<?>> MEMORY_TYPES, List<SensorType<?>> SENSOR_TYPES) {
        MEMORY_TYPES.forEach(module -> {
            if (!brain.f_21843_.containsKey(module)) {
                brain.f_21843_.put(module, Optional.empty());
            }
        });
        SENSOR_TYPES.forEach(type -> {
            SensorType stype = type;
            Sensor sense = stype.m_26827_();
            brain.f_21844_.put(stype, sense);
        });
        brain.f_21844_.values().forEach(sensor -> {
            for (MemoryModuleType memorymoduletype : sensor.m_7163_()) {
                if (brain.f_21843_.containsKey(memorymoduletype)) continue;
                brain.f_21843_.put(memorymoduletype, Optional.empty());
            }
        });
    }

    public static void removeMatchingTasks(Brain<?> brain, Predicate<Behavior<?>> match) {
        brain.f_21845_.forEach((i, map) -> map.values().forEach(s -> s.removeIf(match)));
    }

    public static void addToActivity(Brain<?> brain, Activity act, Collection<Pair<Integer, ? extends Behavior<? super LivingEntity>>> tasks) {
        tasks.forEach(pair -> {
            Integer prior = (Integer)pair.getFirst();
            Behavior task = (Behavior)pair.getSecond();
            brain.f_21845_.computeIfAbsent(prior, val -> Maps.newHashMap()).computeIfAbsent(act, tmp -> Sets.newLinkedHashSet()).add(task);
        });
    }
}

