/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.ai;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import thut.api.entity.ai.MemoryModuleTypes;
import thut.api.entity.ai.PosWrapWrap;
import thut.api.maths.Vector3;

public class RootTask<E extends LivingEntity>
extends Behavior<E> {
    public static boolean doLoadThrottling = false;
    public static int runRate = 10;
    public static Comparator<MemoryModuleType<?>> _NO_ORDER = (a, b) -> 0;
    protected final Map<MemoryModuleType<?>, MemoryStatus> neededMems;
    private final MemoryRequriment[] memoryRequirements;
    protected E entity;
    protected boolean runWhileDead = false;
    protected int _run_rate = 10;
    protected boolean tempRun = false;
    protected boolean tempCont = false;

    public static Map<MemoryModuleType<?>, MemoryStatus> merge(Map<MemoryModuleType<?>, MemoryStatus> mems2, Map<MemoryModuleType<?>, MemoryStatus> mems3) {
        HashMap ret = Maps.newHashMap();
        ret.putAll(mems2);
        ret.putAll(mems3);
        return ImmutableMap.copyOf((Map)ret);
    }

    public RootTask(E entity, Map<MemoryModuleType<?>, MemoryStatus> neededMems, int duration, int maxDuration) {
        super(neededMems, duration, maxDuration);
        this.entity = entity;
        this.neededMems = neededMems;
        this.memoryRequirements = new MemoryRequriment[neededMems.size()];
        this.initMems(this.memoryRequirements, neededMems);
    }

    public RootTask(E entity, Map<MemoryModuleType<?>, MemoryStatus> neededMems, int duration) {
        this(entity, neededMems, duration, duration);
    }

    public RootTask(E entity, Map<MemoryModuleType<?>, MemoryStatus> neededMems) {
        this(entity, neededMems, 60);
    }

    public RootTask(Map<MemoryModuleType<?>, MemoryStatus> neededMems, int duration) {
        this(null, neededMems, duration);
    }

    public RootTask(Map<MemoryModuleType<?>, MemoryStatus> neededMems, int duration, int maxDuration) {
        this(null, neededMems, duration, maxDuration);
    }

    public RootTask(Map<MemoryModuleType<?>, MemoryStatus> neededMems) {
        this(null, neededMems, 60);
    }

    protected Comparator<MemoryModuleType<?>> getCheckOrder() {
        return _NO_ORDER;
    }

    protected void initMems(MemoryRequriment[] reqs, Map<MemoryModuleType<?>, MemoryStatus> neededMems) {
        ArrayList neededModules = Lists.newArrayList();
        neededModules.addAll(neededMems.keySet());
        neededModules.sort(this.getCheckOrder());
        for (int i = 0; i < neededModules.size(); ++i) {
            MemoryModuleType mem = (MemoryModuleType)neededModules.get(i);
            MemoryStatus status = neededMems.get(mem);
            reqs[i] = new MemoryRequriment(mem, status);
        }
    }

    protected boolean runTick(E mobIn) {
        int rate = Math.max(runRate, this._run_rate);
        return ((LivingEntity)mobIn).f_19797_ % rate == ((LivingEntity)mobIn).f_19848_ % rate;
    }

    protected void setWalkTo(Vector3 pos, double speed, int dist) {
        this.setWalkTo(pos.toVec3d(), speed, dist);
    }

    protected void setWalkTo(Vec3 pos, double speed, int dist) {
        this.setWalkTo(new WalkTarget(pos, (float)speed, dist));
    }

    protected void setWalkTo(BlockPos pos, double speed, int dist) {
        this.setWalkTo(new WalkTarget(pos, (float)speed, dist));
    }

    protected void setWalkTo(Entity mobIn, double speed, int dist) {
        this.setWalkTo(new WalkTarget((PositionTracker)new EntityTracker(mobIn, false), (float)speed, dist));
    }

    protected void setWalkTo(WalkTarget target) {
        boolean inRange;
        if (!(target.m_26420_() instanceof EntityTracker) && target != null && (inRange = target.m_26420_().m_7024_().m_82509_((Position)this.entity.m_20182_(), (double)target.m_26422_()))) {
            return;
        }
        if (target != null) {
            PosWrapWrap wrapped = new PosWrapWrap(target.m_26420_(), this.loadThrottle());
            target = new WalkTarget((PositionTracker)wrapped, target.m_26421_(), target.m_26422_());
        }
        this.entity.m_6274_().m_21879_(MemoryModuleTypes.WALK_TARGET, (Object)target);
    }

    protected final boolean isPaused(E mobIn) {
        if (!this.loadThrottle() || !doLoadThrottling) {
            return false;
        }
        return !this.runTick(mobIn);
    }

    protected boolean m_7773_(long gameTime) {
        if (!this.canTimeOut()) {
            return false;
        }
        return super.m_7773_(gameTime);
    }

    public boolean loadThrottle() {
        return false;
    }

    protected boolean canTimeOut() {
        return false;
    }

    protected boolean simpleRun() {
        return false;
    }

    protected boolean shouldNotRun(E mobIn) {
        return false;
    }

    public boolean m_22543_(E mobIn) {
        boolean ret;
        block8: {
            ret = true;
            this.entity = mobIn;
            if (this.simpleRun() && !this.runTick(mobIn)) {
                ret = false;
            } else if (this.shouldNotRun(mobIn)) {
                ret = false;
            } else if (this.isPaused(mobIn)) {
                ret = this.tempCont;
            } else {
                Brain brain = mobIn.m_6274_();
                for (MemoryRequriment mem : this.memoryRequirements) {
                    if (brain.m_21876_(mem.memory(), mem.status())) continue;
                    ret = false;
                    break block8;
                }
                if (!this.runWhileDead && !mobIn.m_6084_()) {
                    ret = false;
                }
            }
        }
        this.tempCont = ret;
        return ret;
    }

    public record MemoryRequriment(MemoryModuleType<?> memory, MemoryStatus status) {
    }
}

