/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.animation;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import thut.api.entity.animation.Animators;
import thut.api.maths.Vector3;
import thut.core.client.render.animation.AnimationXML;

public class Animation {
    private UUID id;
    public UUID _uuid = UUID.randomUUID();
    public String name = "";
    public String identifier = "";
    public int length = -1;
    public int priority = 10;
    public boolean loops = true;
    public boolean hasLimbBased = false;
    public Vector3 _shift = new Vector3();
    public Map<String, Animators.IAnimator> sets = new Object2ObjectOpenHashMap();

    public Animators.IAnimator getComponents(String key) {
        return this.sets.get(key);
    }

    public int getLength() {
        if (this.length == -1) {
            this.initLength();
        }
        return this.length;
    }

    public Animation init(AnimationXML.Phase tag, @Nullable IPartRenamer renamer) {
        return this;
    }

    protected String get(AnimationXML.Phase phase, QName value) {
        return phase.values.getOrDefault(value, "");
    }

    protected String get(AnimationXML.Phase phase, String value) {
        return phase.values.getOrDefault(new QName(value), "");
    }

    public void initLength() {
        this.length = -1;
        this.hasLimbBased = false;
        for (Map.Entry<String, Animators.IAnimator> entry : this.sets.entrySet()) {
            this.length = Math.max(this.length, entry.getValue().getLength());
            this.hasLimbBased = this.hasLimbBased || entry.getValue().hasLimbBased();
        }
    }

    public boolean equals(Object obj) {
        if (this.id == null) {
            if (this.identifier.isEmpty()) {
                this.identifier = this.name;
            }
            this.id = new UUID(this.identifier.hashCode(), (this.identifier.hashCode() << 16) + this.getLength());
        }
        if (obj instanceof Animation) {
            Animation anim = (Animation)obj;
            return anim.id.equals(this.id);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.id == null) {
            if (this.identifier.isEmpty()) {
                this.identifier = this.name;
            }
            this.id = new UUID(this.identifier.hashCode(), (this.identifier.hashCode() << 16) + this.getLength());
        }
        return this.id.hashCode();
    }

    public String toString() {
        this.length = this.getLength();
        return this.name + "|" + this.identifier + "|" + this.loops + "|" + this.length;
    }

    public static interface IPartRenamer {
        public void convertToIdents(String[] var1);
    }
}

