/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.animation;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import org.nfunk.jep.JEP;
import thut.api.entity.IAnimated;
import thut.api.entity.animation.Animation;
import thut.api.entity.animation.AnimationComponent;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.common.ThutCore;

public class Animators {
    private static final Vector4 _rot = new Vector4();

    public static class FunctionAnimation
    implements IAnimator {
        public JEP[] rotFunctions;
        public JEP[] posFunctions;
        public JEP[] scaleFunctions;
        private boolean hidden;
        private boolean limbBased;
        float[] dr = new float[3];
        float[] ds = new float[3];
        float[] dx = new float[3];
        private int[] colours = new int[]{-1, -1, -1, -1};

        public static void fillJEPs(JEP[] jeps, String _funcs) {
            String[] funcs;
            block22: for (String s : funcs = _funcs.split(",")) {
                int i;
                String[] args = s.split(":");
                switch (args[0]) {
                    case "x": {
                        i = 0;
                        break;
                    }
                    case "y": {
                        i = 1;
                        break;
                    }
                    case "z": {
                        i = 2;
                        break;
                    }
                    case "rx": {
                        i = 0;
                        break;
                    }
                    case "ry": {
                        i = 1;
                        break;
                    }
                    case "rz": {
                        i = 2;
                        break;
                    }
                    case "dx": {
                        i = 0;
                        break;
                    }
                    case "dy": {
                        i = 1;
                        break;
                    }
                    case "dz": {
                        i = 2;
                        break;
                    }
                    default: {
                        ThutCore.LOGGER.error("Malformed function animation {}", (Object)s);
                        continue block22;
                    }
                }
                jeps[i] = new JEP();
                jeps[i].addStandardFunctions();
                jeps[i].addStandardConstants();
                jeps[i].addVariable("t", 0.0);
                jeps[i].addVariable("l", 0.0);
                jeps[i].parseExpression(args[1]);
            }
        }

        public static FunctionAnimation makeRotationTest(String rotations) {
            JEP[] rots = new JEP[3];
            FunctionAnimation.fillJEPs(rots, rotations);
            return new FunctionAnimation(rots);
        }

        public static FunctionAnimation makeOffsetTest(String offsets) {
            JEP[] offs = new JEP[3];
            FunctionAnimation.fillJEPs(offs, offsets);
            return new FunctionAnimation(new JEP[3], offs);
        }

        public FunctionAnimation(JEP[] rotFunctions) {
            this.rotFunctions = rotFunctions;
            this.posFunctions = new JEP[3];
            this.scaleFunctions = new JEP[3];
        }

        public FunctionAnimation(JEP[] rotFunctions, JEP[] posFunctions) {
            this.rotFunctions = rotFunctions;
            this.posFunctions = posFunctions;
            this.scaleFunctions = new JEP[3];
        }

        public FunctionAnimation(JEP[] rotFunctions, JEP[] posFunctions, JEP[] scaleFunctions) {
            this.rotFunctions = rotFunctions;
            this.posFunctions = posFunctions;
            this.scaleFunctions = scaleFunctions;
        }

        @Override
        public boolean animate(Animation animation, IAnimated.IAnimationHolder holder, IExtendedModelPart part, float partialTick, float limbSwing, int tick) {
            if (this.hidden) {
                part.setHidden(true);
                return true;
            }
            int aniTick = tick;
            float time1 = aniTick;
            float time2 = 0.0f;
            float limbSpeedFactor = 3.0f;
            time2 = limbSwing * 3.0f;
            aniTick = (int)(time1 += partialTick);
            Vector3 temp = animation._shift.clear();
            if (this.colours[0] != -1) {
                part.setRGBABrO(null, this.colours[0], this.colours[1], this.colours[2], this.colours[3], Integer.MIN_VALUE, -1);
            }
            for (int i = 0; i < 3; ++i) {
                this.dr[i] = 0.0f;
                this.ds[i] = 1.0f;
                this.dx[i] = 0.0f;
                if (this.rotFunctions[i] != null) {
                    this.rotFunctions[i].setVarValue("t", Float.valueOf(time1));
                    this.rotFunctions[i].setVarValue("l", Float.valueOf(time2));
                    this.dr[i] = (float)this.rotFunctions[i].getValue();
                }
                if (this.scaleFunctions[i] != null) {
                    this.scaleFunctions[i].setVarValue("t", Float.valueOf(time1));
                    this.scaleFunctions[i].setVarValue("l", Float.valueOf(time2));
                    this.ds[i] = (float)this.scaleFunctions[i].getValue();
                }
                if (this.posFunctions[i] == null) continue;
                this.posFunctions[i].setVarValue("t", Float.valueOf(time1));
                this.posFunctions[i].setVarValue("l", Float.valueOf(time2));
                this.dx[i] = (float)this.posFunctions[i].getValue() / 16.0f;
            }
            part.setPreTranslations(temp.set((Object)this.dx));
            part.setPreScale(temp.set((Object)this.ds));
            Quaternion quat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
            if (this.dr[2] != 0.0f) {
                quat.m_80148_(Vector3f.f_122224_.m_122240_(this.dr[2]));
            }
            if (this.dr[0] != 0.0f) {
                quat.m_80148_(Vector3f.f_122223_.m_122240_(this.dr[0]));
            }
            if (this.dr[1] != 0.0f) {
                quat.m_80148_(Vector3f.f_122227_.m_122240_(this.dr[1]));
            }
            part.setPreRotations(_rot.set(quat));
            return true;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public boolean hasLimbBased() {
            return this.limbBased;
        }

        @Override
        public void setLimbBased() {
            this.limbBased = true;
        }

        @Override
        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }

    public static class KeyframeAnimator
    implements IAnimator {
        public final List<AnimationComponent> components;
        private int length = -1;
        private boolean limbBased;

        public KeyframeAnimator(List<AnimationComponent> components) {
            this.components = components;
            this.initLength();
        }

        @Override
        public boolean animate(Animation animation, IAnimated.IAnimationHolder holder, IExtendedModelPart part, float partialTick, float limbSwing, int tick) {
            boolean animated = false;
            Vector3 temp = animation._shift.clear();
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float sx = 1.0f;
            float sy = 1.0f;
            float sz = 1.0f;
            int aniTick = tick;
            float time1 = aniTick;
            float time2 = 0.0f;
            int animationLength = animation.getLength();
            animationLength = Math.max(1, animationLength);
            float limbSpeedFactor = 3.0f;
            time1 = (time1 + partialTick) % (float)animationLength;
            time2 = limbSwing * 3.0f % (float)animationLength;
            aniTick = (int)time1;
            for (AnimationComponent component : this.components) {
                float time;
                float f = time = component.limbBased ? time2 : time1;
                if (component.limbBased) {
                    aniTick = (int)time2;
                }
                if (!(time >= (float)component.startKey)) continue;
                animated = true;
                float componentTimer = time - (float)component.startKey;
                if (componentTimer > (float)component.length) {
                    componentTimer = component.length;
                }
                int length = component.length == 0 ? 1 : component.length;
                float ratio = componentTimer / (float)length;
                temp.addTo(component.posChange[0] * (double)ratio + component.posOffset[0], component.posChange[1] * (double)ratio + component.posOffset[1], component.posChange[2] * (double)ratio + component.posOffset[2]);
                rx += (float)(component.rotChange[0] * (double)ratio + component.rotOffset[0]);
                ry += (float)(component.rotChange[1] * (double)ratio + component.rotOffset[1]);
                rz += (float)(component.rotChange[2] * (double)ratio + component.rotOffset[2]);
                sx += (float)(component.scaleChange[0] * (double)ratio + component.scaleOffset[0]);
                sy += (float)(component.scaleChange[1] * (double)ratio + component.scaleOffset[1]);
                sz += (float)(component.scaleChange[2] * (double)ratio + component.scaleOffset[2]);
                part.setHidden(component.hidden);
            }
            holder.setStep(animation, aniTick + 2);
            if (animated) {
                part.setPreTranslations(temp);
                part.setPreScale(temp.set(sx, sy, sz));
                Quaternion quat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
                if (rz != 0.0f) {
                    quat.m_80148_(Vector3f.f_122224_.m_122240_(rz));
                }
                if (rx != 0.0f) {
                    quat.m_80148_(Vector3f.f_122223_.m_122240_(rx));
                }
                if (ry != 0.0f) {
                    quat.m_80148_(Vector3f.f_122227_.m_122240_(ry));
                }
                part.setPreRotations(_rot.set(quat));
            }
            return animated;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        private void initLength() {
            this.length = -1;
            this.limbBased = false;
            for (AnimationComponent component : this.components) {
                this.length = Math.max(this.length, component.startKey + component.length);
                this.limbBased = this.limbBased || component.limbBased;
            }
        }

        @Override
        public boolean hasLimbBased() {
            return this.limbBased;
        }

        @Override
        public void setLimbBased() {
            this.limbBased = true;
        }

        @Override
        public void setHidden(boolean hidden) {
            for (AnimationComponent component : this.components) {
                component.hidden = hidden;
            }
        }
    }

    public static interface IAnimator {
        public boolean animate(Animation var1, IAnimated.IAnimationHolder var2, IExtendedModelPart var3, float var4, float var5, int var6);

        default public void setColours(int ... rgba) {
        }

        public int getLength();

        public boolean hasLimbBased();

        public void setLimbBased();

        public void setHidden(boolean var1);
    }
}

