/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import thut.api.ThutCaps;
import thut.api.entity.IAnimated;
import thut.api.entity.animation.Animation;

public class CapabilityAnimation {

    public static class DefaultImpl
    implements IAnimated.IAnimationHolder,
    ICapabilitySerializable<CompoundTag> {
        private static final List<Animation> EMPTY = Collections.emptyList();
        private final LazyOptional<IAnimated.IAnimationHolder> holder = LazyOptional.of(() -> this);
        Map<String, List<Animation>> anims = Maps.newHashMap();
        List<Animation> playingList = EMPTY;
        Object2IntOpenHashMap<UUID> non_static = new Object2IntOpenHashMap();
        List<Animation> keys = Lists.newArrayList();
        public String _default;
        String pending = this._default = "idle";
        String playing = this._default;
        boolean fixed = false;
        IAnimated.HeadInfo head = new IAnimated.HeadInfo();
        boolean init = false;

        @Override
        public void clean() {
            this.pending = this._default;
            this.playing = this._default;
            this.playingList = this.anims.getOrDefault(this.pending, EMPTY);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.ANIMCAP.orEmpty(cap, this.holder);
        }

        @Override
        public String getPendingAnimations() {
            return this.pending;
        }

        @Override
        public void initAnimations(Map<String, List<Animation>> map, String _default) {
            if (this.init) {
                return;
            }
            map.forEach((s, l) -> this.anims.computeIfAbsent((String)s, s2 -> Lists.newArrayList((Iterable)l)));
            this._default = _default;
            this.init = true;
        }

        @Override
        public List<Animation> getPlaying() {
            if (this.keys.isEmpty() && !this.pending.isEmpty()) {
                this.playingList = this.anims.getOrDefault(this.pending, EMPTY);
                this.playing = this.pending;
                this.non_static.clear();
                for (Animation a : this.playingList) {
                    if (a.getLength() <= 0) continue;
                    this.non_static.put((Object)a._uuid, 0);
                    this.keys.add(a);
                }
            }
            return this.playingList;
        }

        @Override
        public void setPendingAnimations(List<Animation> list, String name) {
            if (name.equals(this.playing) || name.equals(this.pending)) {
                return;
            }
            this.anims.put(name, Lists.newArrayList(list));
            if (this.fixed) {
                this.pending = this.playing;
            } else {
                String transitionKey = "%s->%s".formatted(this.playing, name);
                if (!this.anims.containsKey(transitionKey)) {
                    this.clean();
                }
                this.pending = name;
            }
            this.getPlaying();
        }

        @Override
        public void setStep(Animation animation, float step) {
            boolean finished;
            int l = animation.getLength();
            boolean bl = finished = l != 0 && step > (float)l || animation.hasLimbBased;
            if (!(!finished || animation.loops && this.pending.equals(this.playing))) {
                this.non_static.put((Object)animation._uuid, 0);
            } else {
                this.non_static.put((Object)animation._uuid, l != 0 ? l : 10);
            }
        }

        @Override
        public String getAnimation(Entity entityIn) {
            return this.playing;
        }

        @Override
        public void preRun() {
            this.non_static.replaceAll((a, i) -> 0);
        }

        @Override
        public void postRun() {
            this.keys.removeIf(a -> {
                int i = this.non_static.getInt((Object)a._uuid);
                if (i <= 0) {
                    this.non_static.removeInt((Object)a._uuid);
                    return true;
                }
                return false;
            });
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("pl", this.playing);
            tag.m_128359_("pn", this.pending);
            tag.m_128379_("f", this.fixed);
            if (this.fixed) {
                tag.m_128350_("Hy", this.head.headYaw);
                tag.m_128350_("Hp", this.head.headPitch);
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playing = nbt.m_128461_("pl");
            this.pending = nbt.m_128461_("pn");
            this.fixed = nbt.m_128471_("f");
            if (this.fixed) {
                this.head.fixed = true;
                this.head.headYaw = nbt.m_128457_("Hy");
                this.head.headPitch = nbt.m_128457_("Hp");
            }
        }

        @Override
        public boolean isFixed() {
            return this.fixed;
        }

        @Override
        public IAnimated.HeadInfo getHeadInfo() {
            return this.head;
        }

        @Override
        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }

        @Override
        public void overridePlaying(String anim) {
            this.playing = anim;
        }
    }
}

