/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.block.TempBlock;
import thut.api.entity.blockentity.block.TempTile;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.api.entity.blockentity.world.WorldEntity;
import thut.api.item.ItemList;
import thut.api.maths.Vector3;
import thut.core.common.ThutCore;
import thut.crafts.ThutCrafts;

public abstract class BlockEntityBase
extends Entity
implements IEntityAdditionalSpawnData,
IBlockEntity {
    public static final EntityDataSerializer<Optional<Vec3>> VEC3DSER = new VecSer();
    static final EntityDataAccessor<Optional<Vec3>> velocity = SynchedEntityData.m_135353_(BlockEntityBase.class, VEC3DSER);
    static final EntityDataAccessor<Optional<Vec3>> position = SynchedEntityData.m_135353_(BlockEntityBase.class, VEC3DSER);
    public BlockPos boundMin = BlockPos.f_121853_;
    public BlockPos boundMax = BlockPos.f_121853_;
    private IBlockEntityWorld fake_world;
    private final boolean shouldRevert = true;
    protected float speedUp = 0.5f;
    protected float speedDown = -0.5f;
    protected float speedHoriz = 0.5f;
    protected float acceleration = 0.05f;
    public boolean toMoveY = false;
    public boolean toMoveX = false;
    public boolean toMoveZ = false;
    public UUID owner;
    public List<AABB> blockBoxes = Lists.newArrayList();
    public BlockState[][][] blocks = null;
    public BlockEntity[][][] tiles = null;
    public BlockEntityUpdater collider;
    BlockEntityInteractHandler interacter;
    BlockPos originalPos = null;
    protected Vector3 F = new Vector3();

    public BlockEntityBase(EntityType<? extends BlockEntityBase> type, Level par1World) {
        super(type, par1World);
        this.f_19811_ = true;
        this.f_19802_ = 0;
        this.f_19794_ = true;
    }

    protected Vector3 getForceDirection() {
        return this.F;
    }

    @Override
    public BlockPos getOriginalPos() {
        if (this.originalPos == null) {
            this.originalPos = this.m_20183_();
        }
        return this.originalPos;
    }

    public Vec3 getV() {
        return ((Optional)this.m_20088_().m_135370_(velocity)).orElse(Vec3.f_82478_);
    }

    public void m_7334_(Entity entity) {
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater(this);
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        return super.m_7111_(player, vec, hand);
    }

    public InteractionResult interactAtFromTile(Player player, Vec3 vec, InteractionHand hand) {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        try {
            return this.interacter.applyPlayerInteraction(player, vec, player.m_21120_(hand), hand);
        }
        catch (Exception e) {
            ThutCore.LOGGER.error("Error handling interactions for " + this, (Throwable)e);
            return super.m_7111_(player, vec, hand);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean isServerWorld() {
        return !this.f_19853_.f_46443_;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6109_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    protected abstract boolean checkAccelerationConditions();

    public void checkCollision() {
        BlockPos.m_121921_((AABB)this.m_20191_()).forEach(p -> {
            BlockEntity te;
            boolean isReplaceable;
            Level world = this.m_9236_();
            BlockState block = world.m_8055_(p);
            ResourceLocation replaceable = new ResourceLocation("thutcore:craft_replace");
            boolean air = block.m_60795_();
            boolean bl = isReplaceable = air || ItemList.is(replaceable, block);
            if (isReplaceable && block.m_60734_() != ThutCrafts.CRAFTBLOCK.get()) {
                boolean flag;
                boolean bl2 = flag = world.m_6425_(p).m_76152_() == Fluids.f_76193_;
                if (!air) {
                    world.m_46961_(p, true);
                }
                world.m_46597_(p, (BlockState)((TempBlock)((Object)((Object)ThutCrafts.CRAFTBLOCK.get()))).m_49966_().m_61124_((Property)TempBlock.WATERLOGGED, (Comparable)Boolean.valueOf(flag)));
            }
            if ((te = world.m_7702_(p)) instanceof TempTile) {
                TempTile tile = (TempTile)te;
                tile.blockEntity = this;
                tile.getShape();
            }
        });
    }

    public void onEntityCollision(Entity entityIn) {
    }

    protected abstract BlockEntityInteractHandler createInteractHandler();

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public final void doMotion() {
        if (this.isServerWorld()) {
            Vec3 v = this.getV().m_82490_(0.8);
            Vector3 a = this.getForceDirection();
            if (a.magSq() < 0.05) {
                this.m_6478_(MoverType.SELF, a.toVec3d());
                v = Vec3.f_82478_;
                this.setV(v);
                this.m_20088_().m_135381_(position, Optional.of(this.m_20182_()));
            } else {
                double vh = this.getSpeedHoriz();
                double v_x = this.getSpeed(this.m_20185_(), this.m_20185_() + a.x, v.m_7096_(), vh, vh);
                double v_y = this.getSpeed(this.m_20186_(), this.m_20186_() + a.y, v.m_7098_(), this.getSpeedUp(), this.getSpeedDown());
                double v_z = this.getSpeed(this.m_20189_(), this.m_20189_() + a.z, v.m_7094_(), vh, vh);
                v = new Vec3(v_x, v_y, v_z);
                this.setV(v);
            }
            if (v.m_82556_() > 0.0) {
                this.m_6478_(MoverType.SELF, v);
            } else {
                this.m_20088_().m_135381_(position, Optional.of(this.m_20182_()));
            }
        } else {
            Optional rOpt = (Optional)this.m_20088_().m_135370_(position);
            if (!rOpt.isPresent()) {
                return;
            }
            Vec3 r_1 = (Vec3)rOpt.get();
            Vec3 r_0 = this.m_20182_();
            Vec3 v = r_1.m_82546_(r_0);
            this.m_20088_().m_135381_(velocity, Optional.of(v));
            if (v.m_82556_() > 0.0) {
                this.m_6478_(MoverType.SELF, v);
            }
        }
    }

    protected void setV(Vec3 vec) {
        if (this.isServerWorld()) {
            this.m_20088_().m_135381_(velocity, Optional.of(vec));
            Vec3 r = this.m_20182_();
            Vec3 v = vec;
            Vec3 a = this.F.normalize().scalarMult(this.getAccel()).toVec3d();
            this.m_20088_().m_135381_(position, Optional.of(r.m_82549_(v).m_82549_(a)));
        }
    }

    protected double getSpeed(double pos, double destPos, double speed, double speedPos, double speedNeg) {
        speedPos = Math.abs(speedPos);
        speedNeg = Math.abs(speedNeg);
        double dr_dt = speed;
        double dr = destPos - pos;
        float dr_dt2 = this.getAccel();
        double t_toStop = Math.abs(dr_dt / (double)dr_dt2);
        double stop_distance = dr_dt * t_toStop;
        if (dr > 0.0) {
            boolean tooSlow;
            if (dr_dt <= 0.0) {
                return Math.min(dr_dt += (double)dr_dt2, speedPos);
            }
            boolean tooFast = stop_distance > dr;
            boolean bl = tooSlow = dr_dt < speedPos;
            if (tooFast) {
                dr_dt -= (double)dr_dt2;
            } else if (tooSlow) {
                dr_dt += (double)dr_dt2;
            }
            return Math.min(dr_dt, speedPos);
        }
        if (dr < 0.0) {
            boolean tooSlow;
            if (dr_dt >= 0.0) {
                return Math.max(dr_dt -= (double)dr_dt2, -speedNeg);
            }
            boolean tooFast = stop_distance > -dr;
            boolean bl = tooSlow = dr_dt > -speedNeg;
            if (tooFast) {
                dr_dt += (double)dr_dt2;
            } else if (tooSlow) {
                dr_dt -= (double)dr_dt2;
            }
            return Math.max(dr_dt, -speedNeg);
        }
        return 0.0;
    }

    public Iterable<ItemStack> m_6168_() {
        return Lists.newArrayList();
    }

    @Override
    public BlockState[][][] getBlocks() {
        return this.blocks;
    }

    public boolean getCanSpawnHere() {
        return false;
    }

    @Override
    public IBlockEntityWorld getFakeWorld() {
        if (this.fake_world == null) {
            this.fake_world = new WorldEntity(this.f_19853_);
            this.fake_world.setBlockEntity(this);
        }
        return this.fake_world;
    }

    @Override
    public BlockEntityInteractHandler getInteractor() {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        return this.interacter;
    }

    @Override
    public BlockPos getMax() {
        return this.boundMax;
    }

    @Override
    public BlockPos getMin() {
        return this.boundMin;
    }

    @Override
    public BlockEntity[][][] getTiles() {
        return this.tiles;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return true;
    }

    protected abstract void onGridAlign();

    protected abstract void preColliderTick();

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        return this.interacter.processInitialInteract(player, player.m_21120_(hand), hand);
    }

    public void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("bounds")) {
            CompoundTag bounds = nbt.m_128469_("bounds");
            this.boundMin = new BlockPos(bounds.m_128459_("minx"), bounds.m_128459_("miny"), bounds.m_128459_("minz"));
            this.boundMax = new BlockPos(bounds.m_128459_("maxx"), bounds.m_128459_("maxy"), bounds.m_128459_("maxz"));
            if (bounds.m_128441_("orix")) {
                this.originalPos = new BlockPos(bounds.m_128459_("orix"), bounds.m_128459_("oriy"), bounds.m_128459_("oriz"));
            }
        }
        this.readBlocks(nbt);
    }

    public void readBlocks(CompoundTag nbt) {
        if (nbt.m_128441_("Blocks")) {
            CompoundTag blockTag = nbt.m_128469_("Blocks");
            int sizeX = blockTag.m_128451_("BlocksLengthX");
            int sizeZ = blockTag.m_128451_("BlocksLengthZ");
            int sizeY = blockTag.m_128451_("BlocksLengthY");
            if (sizeX == 0 || sizeZ == 0) {
                sizeX = sizeZ = nbt.m_128451_("BlocksLength");
            }
            if (sizeY == 0) {
                sizeY = 1;
            }
            this.blocks = new BlockState[sizeX][sizeY][sizeZ];
            this.tiles = new BlockEntity[sizeX][sizeY][sizeZ];
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        BlockState state;
                        String name = "B" + i + "," + k + "," + j;
                        if (!blockTag.m_128441_(name)) continue;
                        this.blocks[i][k][j] = state = NbtUtils.m_129241_((CompoundTag)blockTag.m_128469_(name));
                        if (!blockTag.m_128441_("T" + i + "," + k + "," + j)) continue;
                        try {
                            CompoundTag tag = blockTag.m_128469_("T" + i + "," + k + "," + j);
                            this.tiles[i][k][j] = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)state, (CompoundTag)tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.setBlocks(this.blocks);
            this.setTiles(this.tiles);
        }
    }

    public void m_6210_() {
    }

    public AABB _getBoundingBox() {
        AABB box = super.m_20191_();
        BlockPos size = this.getSize();
        if (this.collider != null && (box.m_82362_() != (double)(size.m_123341_() + 1) || box.m_82376_() != (double)(size.m_123342_() + 1) || box.m_82385_() != (double)(size.m_123343_() + 1))) {
            box = this.collider.getBoundingBox();
            this.m_20011_(box);
        }
        return box;
    }

    protected AABB m_20217_(Pose pose) {
        return this._getBoundingBox();
    }

    public void readSpawnData(FriendlyByteBuf data) {
        this.m_7378_(data.m_130260_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(position, Optional.empty());
        this.f_19804_.m_135372_(velocity, Optional.empty());
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            Objects.requireNonNull(this);
            IBlockEntity.BlockEntityFormer.RevertEntity(this);
        }
        super.m_142687_(reason);
    }

    @Override
    public void setBlocks(BlockState[][][] blocks) {
        this.blocks = blocks;
    }

    @Override
    public void setFakeWorld(IBlockEntityWorld world) {
        this.fake_world = world;
    }

    @Override
    public void setMax(BlockPos pos) {
        this.boundMax = pos;
    }

    @Override
    public void setMin(BlockPos pos) {
        this.boundMin = pos;
    }

    public void m_6034_(double x, double y, double z) {
        this.m_20343_(x, y, z);
    }

    @Override
    public void setTiles(BlockEntity[][][] tiles) {
        this.tiles = tiles;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getBlocks() == null) {
            return;
        }
        if (!this.isAddedToWorld()) {
            this.onAddedToWorld();
        }
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater(this);
        }
        this.m_20011_(this.collider.getBoundingBox());
        this.f_19857_ = 0.0f;
        this.f_19858_ = 0.0f;
        this.preColliderTick();
        this.collider.onUpdate();
        this.doMotion();
        this.checkCollision();
    }

    public void m_7380_(CompoundTag nbt) {
        CompoundTag vector = new CompoundTag();
        vector.m_128347_("minx", (double)this.boundMin.m_123341_());
        vector.m_128347_("miny", (double)this.boundMin.m_123342_());
        vector.m_128347_("minz", (double)this.boundMin.m_123343_());
        vector.m_128347_("maxx", (double)this.boundMax.m_123341_());
        vector.m_128347_("maxy", (double)this.boundMax.m_123342_());
        vector.m_128347_("maxz", (double)this.boundMax.m_123343_());
        vector.m_128347_("orix", (double)this.getOriginalPos().m_123341_());
        vector.m_128347_("oriy", (double)this.getOriginalPos().m_123342_());
        vector.m_128347_("oriz", (double)this.getOriginalPos().m_123343_());
        nbt.m_128365_("bounds", (Tag)vector);
        try {
            this.writeBlocks(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeBlocks(CompoundTag nbt) {
        if (this.blocks != null) {
            CompoundTag blocksTag = new CompoundTag();
            blocksTag.m_128405_("BlocksLengthX", this.blocks.length);
            blocksTag.m_128405_("BlocksLengthY", this.blocks[0].length);
            blocksTag.m_128405_("BlocksLengthZ", this.blocks[0][0].length);
            int sizeX = this.blocks.length;
            int sizeY = this.blocks[0].length;
            int sizeZ = this.blocks[0][0].length;
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        BlockState b = this.blocks[i][k][j];
                        if (b == null) continue;
                        blocksTag.m_128365_("B" + i + "," + k + "," + j, (Tag)NbtUtils.m_129202_((BlockState)b));
                        try {
                            if (this.tiles[i][k][j] == null) continue;
                            CompoundTag tag = this.tiles[i][k][j].m_187480_();
                            blocksTag.m_128365_("T" + i + "," + k + "," + j, (Tag)tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            nbt.m_128365_("Blocks", (Tag)blocksTag);
        }
    }

    public float getSpeedUp() {
        return this.speedUp;
    }

    public float getSpeedDown() {
        return this.speedDown;
    }

    public float getSpeedHoriz() {
        return this.speedHoriz;
    }

    public float getAccel() {
        return this.acceleration;
    }

    public void writeSpawnData(FriendlyByteBuf data) {
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        data.m_130079_(tag);
    }

    private static class VecSer
    implements EntityDataSerializer<Optional<Vec3>> {
        private VecSer() {
        }

        public Optional<Vec3> copy(Optional<Vec3> value) {
            if (value.isPresent()) {
                return Optional.of(new Vec3(value.get().f_82479_, value.get().f_82480_, value.get().f_82481_));
            }
            return Optional.empty();
        }

        public EntityDataAccessor<Optional<Vec3>> m_135021_(int id) {
            return new EntityDataAccessor(id, (EntityDataSerializer)this);
        }

        public Optional<Vec3> read(FriendlyByteBuf buf) {
            if (!buf.isReadable()) {
                return Optional.empty();
            }
            return Optional.of(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }

        public void write(FriendlyByteBuf buf, Optional<Vec3> opt) {
            if (opt.isPresent()) {
                Vec3 value = opt.get();
                buf.writeDouble(value.f_82479_);
                buf.writeDouble(value.f_82480_);
                buf.writeDouble(value.f_82481_);
            }
        }
    }

    public static class BlockEntityType<T extends BlockEntityBase>
    extends EntityType<T> {
        public BlockEntityType(EntityType.EntityFactory<T> factory) {
            super(factory, MobCategory.MISC, true, false, true, true, ImmutableSet.of(), new EntityDimensions(1.0f, 1.0f, true), 64, 1);
        }

        public T customClientSpawn(PlayMessages.SpawnEntity packet, Level world) {
            return (T)((BlockEntityBase)this.m_20615_(world));
        }
    }
}

