/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.core.common.ThutCore;

public class BlockEntityUpdater {
    public static boolean autoBlacklist = false;
    final IBlockEntity blockEntity;
    final Entity theEntity;
    List<AABB> blockBoxes = Lists.newArrayList();
    Set<BlockEntity> erroredSet = Sets.newHashSet();
    VoxelShape totalShape = Shapes.m_83040_();
    Vec3 lastShapePos = Vec3.f_82478_;

    public static boolean isWhitelisted(BlockEntity tile) {
        ResourceLocation id = BlockEntityType.m_58954_((BlockEntityType)tile.m_58903_());
        return id == null ? true : !IBlockEntity.TEBLACKLIST.contains(id.toString());
    }

    public BlockEntityUpdater(IBlockEntity rocket) {
        this.blockEntity = rocket;
        this.theEntity = (Entity)rocket;
        Vec3 here = this.theEntity.m_20182_();
        this.theEntity.m_20011_(this.getBoundingBox());
        this.theEntity.m_6034_(here.f_82479_, here.f_82480_, here.f_82481_);
    }

    public VoxelShape buildShape() {
        int sizeX = this.blockEntity.getBlocks().length;
        int sizeY = this.blockEntity.getBlocks()[0].length;
        int sizeZ = this.blockEntity.getBlocks()[0][0].length;
        Entity mob = (Entity)this.blockEntity;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos min = this.blockEntity.getMin();
        BlockPos origin = mob.m_20183_();
        IBlockEntityWorld world = this.blockEntity.getFakeWorld();
        if (mob.m_20182_().m_82557_(this.lastShapePos) <= 1.0E-4) {
            return this.totalShape;
        }
        this.lastShapePos = mob.m_20182_();
        int xMin = this.blockEntity.getMin().m_123341_();
        int zMin = this.blockEntity.getMin().m_123343_();
        this.totalShape = Shapes.m_83040_();
        double dx = xMin;
        double dz = zMin;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    VoxelShape shape;
                    pos.m_122178_(i, j, k);
                    BlockState state = this.blockEntity.getBlocks()[i][j][k];
                    pos.m_122178_(i + min.m_123341_() + origin.m_123341_(), j + min.m_123342_() + origin.m_123342_(), k + min.m_123343_() + origin.m_123343_());
                    if (state == null || (shape = state.m_60808_((BlockGetter)world, (BlockPos)pos)) == null || shape.m_83281_()) continue;
                    shape = shape.m_83216_(mob.m_20185_() + (double)i - dx, mob.m_20186_() + (double)j + (double)min.m_123342_(), mob.m_20189_() + (double)k - dz);
                    this.totalShape = Shapes.m_83113_((VoxelShape)this.totalShape, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
                }
            }
        }
        return this.totalShape;
    }

    private static double getIntersect(double minA, double minB, double minC, double maxA, double maxB, double maxC) {
        boolean min_min;
        if (minC != minA && minC != maxA && maxC != minA && maxC != maxA) {
            return 0.0;
        }
        double dmax_max = maxA - maxB;
        double dmax_min = maxA - minB;
        double dmin_max = minA - maxB;
        double dmin_min = minA - minB;
        boolean max_max = maxA == maxB;
        boolean max_min = maxA == minB;
        boolean min_max = minA == maxB;
        boolean bl = min_min = minA == minB;
        if (min_min && Mth.m_14082_((double)minB, (double)minC)) {
            min_min = false;
        }
        if (max_max && Mth.m_14082_((double)maxB, (double)maxC)) {
            max_max = false;
        }
        if (max_min && Mth.m_14082_((double)maxB, (double)minC)) {
            max_min = false;
        }
        if (min_max && Mth.m_14082_((double)minB, (double)maxC)) {
            min_max = false;
        }
        if (!(min_min || max_max || max_min || min_max)) {
            return 0.0;
        }
        double intersectAmount = 0.0;
        if (min_min) {
            intersectAmount = dmax_min;
        }
        if (max_max) {
            intersectAmount = dmin_max;
        }
        if (max_min) {
            intersectAmount = -dmax_max;
        }
        if (min_max) {
            intersectAmount = -dmin_min;
        }
        return intersectAmount;
    }

    private static double getIntersect(Direction.Axis axis, AABB boxA, AABB boxB, AABB boxC) {
        switch (axis) {
            case X: {
                return BlockEntityUpdater.getIntersect(boxA.f_82288_, boxB.f_82288_, boxC.f_82288_, boxA.f_82291_, boxB.f_82291_, boxC.f_82291_);
            }
            case Y: {
                return BlockEntityUpdater.getIntersect(boxA.f_82289_, boxB.f_82289_, boxC.f_82289_, boxA.f_82292_, boxB.f_82292_, boxC.f_82292_);
            }
            case Z: {
                return BlockEntityUpdater.getIntersect(boxA.f_82290_, boxB.f_82290_, boxC.f_82290_, boxA.f_82293_, boxB.f_82293_, boxC.f_82293_);
            }
        }
        return 0.0;
    }

    public static boolean intersectsOrAdjacent(AABB boxA, AABB boxB) {
        return boxA.f_82288_ <= boxB.f_82291_ && boxA.f_82291_ >= boxB.f_82288_ && boxA.f_82289_ <= boxB.f_82292_ && boxA.f_82292_ >= boxB.f_82289_ && boxA.f_82290_ <= boxB.f_82293_ && boxA.f_82293_ >= boxB.f_82290_;
    }

    public static void fill(List<AABB> boxes, AABB textBox, VoxelShape from) {
        boxes.clear();
        from.m_83286_((x0, y0, z0, x1, y1, z1) -> {
            AABB box = new AABB(x0, y0, z0, x1, y1, z1);
            if (BlockEntityUpdater.intersectsOrAdjacent(box, textBox)) {
                boxes.add(box);
            }
        });
    }

    public static boolean applyEntityCollision(Entity entity, AABB entityBox, List<AABB> blockBoxes, Vec3 ref_motion) {
        boolean collided;
        AABB toUse;
        if (blockBoxes.isEmpty()) {
            return false;
        }
        double dx = 0.0;
        double dz = 0.0;
        double dy = 0.0;
        Vec3 motion_b = entity.m_20184_();
        boolean serverSide = entity.m_9236_().f_46443_;
        boolean isPlayer = entity instanceof Player;
        if (isPlayer) {
            serverSide = entity instanceof ServerPlayer;
        }
        Vec3 diffV = ref_motion.m_82546_(motion_b);
        AABB boundingBox = entityBox;
        if (isPlayer && serverSide) {
            ServerPlayer player = (ServerPlayer)entity;
            dx = player.f_36105_ - player.f_36102_;
            dy = player.f_36106_ - player.f_36103_;
            dz = player.f_36075_ - player.f_36104_;
            motion_b = new Vec3(dx, dy, dz).m_82490_(0.5);
        }
        AABB testBox = boundingBox.m_82363_(diffV.f_82479_, diffV.f_82480_, diffV.f_82481_);
        dx = 0.0;
        dy = 0.0;
        dz = 0.0;
        boolean colX = false;
        boolean colY = false;
        boolean colZ = false;
        AABB orig = toUse = testBox;
        for (AABB aabb : blockBoxes) {
            boolean max;
            double dx1 = 0.0;
            double dy1 = 0.0;
            double dz1 = 0.0;
            if (!BlockEntityUpdater.intersectsOrAdjacent(aabb, toUse)) continue;
            AABB inter = toUse.m_82323_(aabb);
            if (inter.m_82376_() == 0.0 && inter.f_82289_ == aabb.f_82292_) {
                colY = true;
            }
            if (inter.m_82362_() == 0.0 || inter.m_82376_() == 0.0 || inter.m_82385_() == 0.0) continue;
            dx1 = BlockEntityUpdater.getIntersect(Direction.Axis.X, inter, toUse, aabb);
            dy1 = BlockEntityUpdater.getIntersect(Direction.Axis.Y, inter, toUse, aabb);
            dz1 = BlockEntityUpdater.getIntersect(Direction.Axis.Z, inter, toUse, aabb);
            if (dx1 != 0.0 && dz1 != 0.0) {
                boolean bl = max = Math.abs(dx1) > Math.abs(dz1);
                if (max) {
                    dx1 = 0.0;
                } else {
                    dz1 = 0.0;
                }
            }
            if (dy1 != 0.0 && dx1 != 0.0) {
                boolean bl = max = Math.abs(dx1) > Math.abs(dy1);
                if (max) {
                    dx1 = 0.0;
                } else {
                    dy1 = 0.0;
                }
            }
            if (dy1 != 0.0 && dz1 != 0.0) {
                boolean bl = max = Math.abs(dz1) > Math.abs(dy1);
                if (max) {
                    dz1 = 0.0;
                } else {
                    dy1 = 0.0;
                }
            }
            if (dy1 == 0.0 && (dz1 != 0.0 || dx1 != 0.0) && (dy = inter.f_82292_ - toUse.f_82289_) >= 0.0 && dy < (double)entity.getStepHeight()) {
                boolean valid = true;
                for (AABB aabb2 : blockBoxes) {
                    if (aabb2 == aabb || !aabb2.m_82381_(toUse)) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    dx1 = 0.0;
                    dz1 = 0.0;
                    dy1 = dy;
                }
            }
            colX = colX || dx1 != 0.0;
            colY = colY || dy1 != 0.0;
            colZ = colZ || dz1 != 0.0;
            toUse = toUse.m_82386_(dx1, dy1, dz1);
        }
        dx = toUse.f_82288_ - orig.f_82288_;
        dy = toUse.f_82289_ - orig.f_82289_;
        dz = toUse.f_82290_ - orig.f_82290_;
        boolean bl = collided = colX || colY || colZ;
        if (collided) {
            Vec3 motion;
            motion_b = entity.m_20184_();
            if (colY) {
                motion = new Vec3(0.0, dy, 0.0);
                entity.m_6478_(MoverType.SELF, motion);
                dy = ref_motion.f_82480_;
            } else {
                dy = motion_b.f_82480_;
            }
            if (colX) {
                motion = new Vec3(dx, 0.0, 0.0);
                entity.m_6478_(MoverType.SELF, motion);
                dx = ref_motion.f_82479_;
            } else {
                dx = 0.9 * motion_b.f_82479_;
            }
            if (colZ) {
                motion = new Vec3(0.0, 0.0, dz);
                entity.m_6478_(MoverType.SELF, motion);
                dz = ref_motion.f_82481_;
            } else {
                dz = 0.9 * motion_b.f_82481_;
            }
            entity.m_20334_(dx, dy, dz);
            if (colY) {
                entity.m_6853_(true);
                entity.m_142535_(entity.f_19789_, 0.0f, DamageSource.f_19318_);
                entity.f_19789_ = 0.0f;
            }
        }
        return collided;
    }

    public AABB getBoundingBox() {
        BlockPos size = this.blockEntity.getSize();
        double x0 = this.theEntity.m_20185_();
        double y0 = this.theEntity.m_20186_();
        double z0 = this.theEntity.m_20189_();
        double xMin = x0;
        double yMin = y0;
        double zMin = z0;
        double xMax = x0 + (double)size.m_123341_() + 1.0;
        double yMax = y0 + (double)size.m_123342_() + 1.0;
        double zMax = z0 + (double)size.m_123343_() + 1.0;
        if (size.m_123342_() <= 1) {
            yMax += 1.0;
        }
        return new AABB(xMin, yMin, zMin, xMax, yMax, zMax).m_82400_(0.0);
    }

    public void onUpdate() {
        Level level;
        if (this.blockEntity.getBlocks() == null) {
            return;
        }
        BlockPos dims = this.blockEntity.getSize();
        double uMax = Math.max(dims.m_123341_(), Math.max(dims.m_123342_(), dims.m_123343_()));
        this.theEntity.m_9236_().increaseMaxEntityRadius(uMax);
        EntityDimensions size = this.theEntity.m_6972_(this.theEntity.m_20089_());
        if (size.f_20377_ != (float)(dims.m_123341_() + 1)) {
            size = EntityDimensions.m_20398_((float)(1 + dims.m_123341_()), (float)this.blockEntity.getMax().m_123342_());
            this.blockEntity.setSize(size);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int sizeX = dims.m_123341_();
        int sizeY = dims.m_123342_();
        int sizeZ = dims.m_123343_();
        IBlockEntityWorld iBlockEntityWorld = this.blockEntity.getFakeWorld();
        Level world = iBlockEntityWorld instanceof Level ? (level = (Level)iBlockEntityWorld) : this.theEntity.m_9236_();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    pos.m_122169_((double)i + this.theEntity.m_20185_(), (double)j + this.theEntity.m_20186_(), (double)k + this.theEntity.m_20189_());
                    BlockEntity tile = this.blockEntity.getTiles()[i][j][k];
                    if (tile != null) {
                        tile.m_142339_(world);
                    }
                    if (!(tile instanceof TickingBlockEntity)) continue;
                    TickingBlockEntity tick = (TickingBlockEntity)tile;
                    if (this.erroredSet.contains(tile) || !BlockEntityUpdater.isWhitelisted(tile)) continue;
                    try {
                        tick.m_142224_();
                        continue;
                    }
                    catch (Throwable e) {
                        ThutCore.LOGGER.error("Error with Tile Entity " + tile, e);
                        this.erroredSet.add(tile);
                        if (!autoBlacklist || BlockEntityType.m_58954_((BlockEntityType)tile.m_58903_()) == null) continue;
                        IBlockEntity.TEBLACKLIST.add(BlockEntityType.m_58954_((BlockEntityType)tile.m_58903_()).toString());
                    }
                }
            }
        }
    }
}

