/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.lib.RegHelper;

public interface IBlockEntity {
    public static final Set<ResourceLocation> BLOCKBLACKLIST = Sets.newHashSet();
    public static final Set<String> TEBLACKLIST = Sets.newHashSet();
    public static final BiMap<Class<?>, ITileRemover> CUSTOMREMOVERS = HashBiMap.create();
    public static final List<ITileRemover> SORTEDREMOVERS = Lists.newArrayList();
    public static final ITileRemover DEFAULTREMOVER = new ITileRemover(){

        @Override
        public void postBlockRemoval(BlockEntity tileIn) {
        }

        @Override
        public void preBlockRemoval(BlockEntity tileIn) {
            tileIn.m_7651_();
        }
    };

    public static void addRemover(ITileRemover remover, Class<?> clas) {
        CUSTOMREMOVERS.put(clas, (Object)remover);
        SORTEDREMOVERS.add(remover);
        Collections.sort(SORTEDREMOVERS, (o1, o2) -> o1.getPriority() - o2.getPriority());
    }

    public static ITileRemover getRemover(BlockEntity tile) {
        ITileRemover ret = (ITileRemover)CUSTOMREMOVERS.get(tile.getClass());
        if (ret != null) {
            return ret;
        }
        for (ITileRemover temp : SORTEDREMOVERS) {
            Class key = (Class)CUSTOMREMOVERS.inverse().get((Object)temp);
            if (!key.isInstance(tile)) continue;
            return temp;
        }
        return DEFAULTREMOVER;
    }

    public BlockState[][][] getBlocks();

    public IBlockEntityWorld getFakeWorld();

    public BlockEntityInteractHandler getInteractor();

    public BlockPos getMax();

    public BlockPos getMin();

    default public BlockPos getSize() {
        return this.getMax().m_121996_((Vec3i)this.getMin());
    }

    public BlockPos getOriginalPos();

    public BlockEntity[][][] getTiles();

    public void setBlocks(BlockState[][][] var1);

    public void setFakeWorld(IBlockEntityWorld var1);

    public void setMax(BlockPos var1);

    public void setMin(BlockPos var1);

    public void setSize(EntityDimensions var1);

    public void setTiles(BlockEntity[][][] var1);

    default public boolean shouldHide(BlockPos pos) {
        BlockEntity tile = this.getFakeWorld().getTile(pos);
        return tile != null && !BlockEntityUpdater.isWhitelisted(tile);
    }

    public static interface ITileRemover {
        default public int getPriority() {
            return 0;
        }

        public void postBlockRemoval(BlockEntity var1);

        public void preBlockRemoval(BlockEntity var1);
    }

    public static class BlockEntityFormer {
        public static BlockState[][][] checkBlocks(Level world, BlockPos min, BlockPos max, BlockPos pos) {
            int xMin = min.m_123341_();
            int zMin = min.m_123343_();
            int xMax = max.m_123341_();
            int zMax = max.m_123343_();
            int yMin = min.m_123342_();
            int yMax = max.m_123342_();
            BlockState[][][] ret = new BlockState[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
            boolean valid = false;
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        BlockPos temp = pos.m_7918_(i, j, k);
                        BlockState state = world.m_8055_(temp);
                        if (BLOCKBLACKLIST.contains(RegHelper.getKey(state.m_60734_()))) {
                            return null;
                        }
                        valid = valid || !state.m_60795_();
                        ret[i - xMin][j - yMin][k - zMin] = state;
                    }
                }
            }
            return valid ? ret : null;
        }

        public static BlockEntity[][][] checkTiles(Level world, BlockPos min, BlockPos max, BlockPos pos) {
            int xMin = min.m_123341_();
            int zMin = min.m_123343_();
            int xMax = max.m_123341_();
            int zMax = max.m_123343_();
            int yMin = min.m_123342_();
            int yMax = max.m_123342_();
            BlockEntity[][][] ret = new BlockEntity[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        BlockPos temp = pos.m_7918_(i, j, k);
                        BlockEntity old = world.m_7702_(temp);
                        if (old == null) continue;
                        CompoundTag tag = old.m_187480_();
                        ret[i - xMin][j - yMin][k - zMin] = BlockEntity.m_155241_((BlockPos)temp, (BlockState)world.m_8055_(temp), (CompoundTag)tag);
                    }
                }
            }
            return ret;
        }

        public static <T extends Entity> T makeBlockEntity(Level world, BlockPos min, BlockPos max, BlockPos pos, EntityType<T> type) {
            Entity ret = type.m_20615_(world);
            AABB box = new AABB(min, max);
            min = new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_);
            max = new BlockPos(box.f_82291_, box.f_82292_, box.f_82293_);
            IBlockEntity entity = (IBlockEntity)ret;
            ret.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            BlockState[][][] blocks = BlockEntityFormer.checkBlocks(world, min, max, pos);
            if (blocks == null) {
                return null;
            }
            entity.setBlocks(blocks);
            entity.setTiles(BlockEntityFormer.checkTiles(world, min, max, pos));
            entity.setMin(min);
            entity.setMax(max);
            BlockEntityFormer.removeBlocks(world, min, max, pos);
            world.m_7967_(ret);
            return (T)ret;
        }

        public static HitResult rayTraceInternal(Vec3 start, Vec3 end, IBlockEntity toTrace) {
            Vec3 diff = end.m_82546_(start);
            double l = diff.m_82553_();
            diff = diff.m_82541_();
            IBlockEntityWorld world = toTrace.getFakeWorld();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (double i = 0.0; i < l; i += 0.1) {
                VoxelShape shape;
                BlockHitResult hit;
                Vec3 spot = start.m_82549_(diff.m_82542_(i, i, i));
                pos.m_122178_(Mth.m_14107_((double)spot.f_82479_), Mth.m_14107_((double)spot.f_82480_), Mth.m_14107_((double)spot.f_82481_));
                BlockState state = world.getBlock((BlockPos)pos);
                if (state == null || world.m_46859_((BlockPos)pos) || (hit = (shape = state.m_60812_((BlockGetter)world, (BlockPos)pos)).m_83220_(start, end, (BlockPos)pos)) == null) continue;
                return hit;
            }
            return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.DOWN, (BlockPos)new BlockPos(end));
        }

        public static void removeBlocks(Level world, BlockPos min, BlockPos max, BlockPos pos) {
            ITileRemover tileHandler;
            BlockEntity tile;
            int k;
            int j;
            int i;
            int xMin = min.m_123341_();
            int zMin = min.m_123343_();
            int xMax = max.m_123341_();
            int zMax = max.m_123343_();
            int yMin = min.m_123342_();
            int yMax = max.m_123342_();
            BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.m_122178_(pos.m_123341_() + i, pos.m_123342_() + j, pos.m_123343_() + k);
                        tile = world.m_7702_((BlockPos)temp);
                        tileHandler = null;
                        if (tile == null) continue;
                        tileHandler = IBlockEntity.getRemover(tile);
                        tileHandler.preBlockRemoval(tile);
                    }
                }
            }
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.m_122178_(pos.m_123341_() + i, pos.m_123342_() + j, pos.m_123343_() + k);
                        tile = world.m_7702_((BlockPos)temp);
                        tileHandler = null;
                        if (tile != null) {
                            tileHandler = IBlockEntity.getRemover(tile);
                        }
                        world.m_7731_((BlockPos)temp, Blocks.f_50016_.m_49966_(), 114);
                        if (tileHandler == null) continue;
                        tileHandler.postBlockRemoval(tile);
                    }
                }
            }
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        temp.m_122178_(pos.m_123341_() + i, pos.m_123342_() + j, pos.m_123343_() + k);
                        world.m_7731_((BlockPos)temp, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }

        public static void RevertEntity(IBlockEntity toRevert) {
            int xMin = toRevert.getMin().m_123341_();
            int zMin = toRevert.getMin().m_123343_();
            int yMin = toRevert.getMin().m_123342_();
            if (toRevert.getBlocks() == null) {
                return;
            }
            int sizeX = toRevert.getBlocks().length;
            int sizeY = toRevert.getBlocks()[0].length;
            int sizeZ = toRevert.getBlocks()[0][0].length;
            Entity entity = (Entity)toRevert;
            for (int i = 0; i < sizeX; ++i) {
                for (int j = 0; j < sizeY; ++j) {
                    for (int k = 0; k < sizeZ; ++k) {
                        BlockEntity newTile;
                        BlockPos pos = new BlockPos((double)(i + xMin) + entity.m_20185_(), (double)(j + yMin) + entity.m_20186_(), (double)(k + zMin) + entity.m_20189_());
                        BlockState state = toRevert.getFakeWorld().getBlock(pos);
                        BlockEntity tile = toRevert.getFakeWorld().getTile(pos);
                        if (state == null) continue;
                        if (!entity.m_9236_().m_46859_(pos)) {
                            entity.m_9236_().m_46961_(pos, true);
                        }
                        entity.m_9236_().m_46597_(pos, state);
                        if (tile == null || (newTile = entity.m_9236_().m_7702_(pos)) == null) continue;
                        newTile.m_142466_(tile.m_187480_());
                    }
                }
            }
            List possibleInside = entity.m_9236_().m_45933_(entity, entity.m_20191_());
            for (Entity e : possibleInside) {
                e.m_6034_(e.m_20185_(), e.m_20186_() + 0.25, e.m_20189_());
            }
        }
    }
}

