/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import thut.api.block.ITickTile;
import thut.api.entity.blockentity.block.TempTile;

public class TempBlock
extends AirBlock
implements EntityBlock {
    public static final IntegerProperty LIGHTLEVEL = IntegerProperty.m_61631_((String)"light", (int)0, (int)15);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public static TempBlock make() {
        return new TempBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76297_).m_60924_(TempBlock::solidCheck).m_60988_().m_60955_().m_60953_(s -> (Integer)s.m_61143_((Property)LIGHTLEVEL)));
    }

    private static boolean solidCheck(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public TempBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIGHTLEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onPlayerInteract);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TempTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return ITickTile.getTicker(world, state, type);
    }

    private void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockHitResult trace = event.getHitVec();
        if (trace == null) {
            return;
        }
        Level world = event.getEntity().m_9236_();
        BlockEntity tile = world.m_7702_(event.getPos());
        if (tile instanceof TempTile) {
            InteractionHand hand;
            TempTile temp = (TempTile)tile;
            Player player = event.getEntity();
            BlockPos pos = event.getPos();
            BlockState state = world.m_8055_(pos);
            InteractionResult result = temp.use(state, world, pos, player, hand = event.getHand(), trace);
            if (result != InteractionResult.PASS) {
                event.setCanceled(true);
                event.setUseBlock(Event.Result.ALLOW);
                event.setUseItem(Event.Result.ALLOW);
            }
        }
    }

    @Deprecated
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TempTile) {
            TempTile temp = (TempTile)tile;
            return temp.use(state, world, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIGHTLEVEL, WATERLOGGED});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof TempTile) {
            TempTile tile = (TempTile)te;
            tile.onVerticalCollide(entity, 0.0f);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float distance) {
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof TempTile) {
            TempTile tile = (TempTile)te;
            distance = tile.onVerticalCollide(entity, distance);
        }
        super.m_142072_(level, state, pos, entity, distance);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof TempTile) {
            TempTile tile = (TempTile)te;
            tile.onVerticalCollide(entity, 0.0f);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TempTile) {
            TempTile temp = (TempTile)te;
            return temp.getShape();
        }
        return Shapes.m_83040_();
    }
}

