/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.block;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import thut.api.block.ITickTile;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.block.TempBlock;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.api.maths.Vector3;
import thut.crafts.ThutCrafts;

public class TempTile
extends BlockEntity
implements ITickTile {
    private static Set<BlockState> NO_INTERACT = Sets.newHashSet();
    public BlockEntityBase blockEntity;
    public VoxelShape shape = null;

    public TempTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ThutCrafts.CRAFTTE.get(), pos, state);
    }

    public TempTile(BlockEntityBase blockEntity, BlockPos pos, BlockState state) {
        this(pos, state);
        this.blockEntity = blockEntity;
    }

    @Override
    public void tick() {
        boolean shouldRemove;
        boolean bl = shouldRemove = this.blockEntity == null;
        if (!shouldRemove) {
            boolean bl2 = shouldRemove = !this.blockEntity.m_6084_();
        }
        if (!shouldRemove) {
            boolean bl3 = shouldRemove = !this.blockEntity.m_20191_().m_82400_(1.01).m_82390_(new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()));
        }
        if (shouldRemove) {
            boolean water = (Boolean)this.m_58900_().m_61143_((Property)TempBlock.WATERLOGGED);
            this.f_58857_.m_7471_(this.m_58899_(), false);
            if (water) {
                this.f_58857_.m_7731_(this.m_58899_(), Blocks.f_49990_.m_49966_(), 3);
            }
        } else {
            int lightF;
            int lightR;
            BlockState fake = this.getEffectiveState();
            BlockState real = this.m_58900_();
            if (fake != null && (lightR = real.getLightEmission((BlockGetter)this.m_58904_(), this.m_58899_())) != (lightF = fake.m_60791_())) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)real.m_61124_((Property)TempBlock.LIGHTLEVEL, (Comparable)Integer.valueOf(lightF)));
            }
        }
    }

    public BlockEntity getEffectiveTile() {
        if (this.blockEntity != null) {
            return this.blockEntity.getFakeWorld().getTile(this.m_58899_());
        }
        return null;
    }

    public BlockState getEffectiveState() {
        if (this.blockEntity != null) {
            return this.blockEntity.getFakeWorld().getBlock(this.m_58899_());
        }
        return null;
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IBlockEntityWorld iBlockEntityWorld;
        BlockState eff = this.getEffectiveState();
        if (eff != null && !NO_INTERACT.contains(eff) && (iBlockEntityWorld = this.blockEntity.getFakeWorld()) instanceof Level) {
            Level level = (Level)iBlockEntityWorld;
            InteractionResult res = InteractionResult.PASS;
            try {
                BlockEntity be = this.getEffectiveTile();
                if (be != null && be.m_58904_() == null) {
                    be.m_142339_(level);
                }
                res = eff.m_60664_(level, player, hand, hit);
            }
            catch (Exception e) {
                e.printStackTrace();
                NO_INTERACT.add(eff);
            }
            if (res != InteractionResult.PASS) {
                return res;
            }
        }
        return this.blockEntity.interactAtFromTile(player, hit.m_82450_(), hand);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        BlockEntity effective = this.getEffectiveTile();
        if (effective != null) {
            return effective.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public VoxelShape getShape() {
        VoxelShape ret = Shapes.m_83040_();
        if (this.blockEntity != null) {
            Vector3 r = new Vector3().set(this.f_58858_);
            VoxelShape shape = this.blockEntity.collider.buildShape();
            if (!shape.m_83281_()) {
                ret = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)shape.m_83216_(-r.x, -r.y, -r.z), (BooleanOp)BooleanOp.f_82689_);
            }
        }
        this.shape = ret;
        return ret;
    }

    public float onVerticalCollide(Entity entity, float distance) {
        VoxelShape there;
        TempTile tile;
        if (entity == this.blockEntity) {
            return distance;
        }
        if (this.blockEntity == null) {
            return distance;
        }
        Vec3 tileV = this.blockEntity.getV();
        Vec3 entityV = entity.m_20184_();
        BlockEntity below = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        BlockEntity above = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        VoxelShape here = this.getShape();
        if (below instanceof TempTile) {
            tile = (TempTile)below;
            there = tile.getShape();
            if (here.m_83281_() && !there.m_83281_()) {
                here = there.m_83216_(0.0, -1.0, 0.0);
            } else if (!there.m_83281_()) {
                here = Shapes.m_83113_((VoxelShape)here, (VoxelShape)there.m_83216_(0.0, -1.0, 0.0), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        if (above instanceof TempTile) {
            tile = (TempTile)above;
            there = tile.getShape();
            if (here.m_83281_() && !there.m_83281_()) {
                here = there.m_83216_(0.0, -1.0, 0.0);
            } else if (!there.m_83281_()) {
                here = Shapes.m_83113_((VoxelShape)here, (VoxelShape)there.m_83216_(0.0, -1.0, 0.0), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.f_8906_.f_9739_ = 0;
            serverplayer.f_8906_.f_9737_ = 0;
        }
        if (!here.m_83281_()) {
            double newVy = tileV.m_7098_() != 0.0 ? tileV.m_7098_() : entityV.m_7098_();
            entity.m_20334_(entityV.m_7096_(), newVy, entityV.m_7094_());
            AABB bounds = here.m_83215_();
            Vec3 entityR = entity.m_20182_();
            double x = entityR.m_7096_();
            double y = bounds.f_82292_ + (double)this.m_58899_().m_123342_() + tileV.m_7098_();
            if (y > entity.m_20191_().f_82292_) {
                y = entity.m_20186_() + tileV.m_7098_();
            }
            double z = entityR.m_7094_();
            if (tileV.m_7098_() > 0.0) {
                entity.m_6034_(x, y, z);
            }
            double d0 = entity.m_20185_();
            double d1 = entity.m_20186_();
            double d2 = entity.m_20189_();
            entityV = entity.m_20184_();
            entity.f_19790_ = entity.f_19854_ = d0 - entityV.f_82479_;
            entity.f_19791_ = entity.f_19855_ = d1 - entityV.f_82480_;
            entity.f_19792_ = entity.f_19856_ = d2 - entityV.f_82481_;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)entity;
                serverplayer.f_19789_ = 0.0f;
            }
        }
        return distance;
    }
}

